/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.util;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import net.sourceforge.jocular.Constants;

public class ResourceTools
implements Constants {
    private static HashMap<String, BufferedImage> m_images = new HashMap();

    public static BufferedImage loadImage(String path) {
        if (path == null) {
            return null;
        }
        BufferedImage result = m_images.get(path);
        if (result == null) {
            Class<?> c = null;
            InputStream is = null;
            URL url = null;
            String p = "net/sourceforge/jocular/resources/" + path;
            c = path.getClass();
            if (c != null) {
                is = c.getResourceAsStream(p);
                url = ClassLoader.getSystemResource(p);
            }
            try {
                result = ImageIO.read(url);
            }
            catch (IOException e) {
                result = null;
            }
            catch (IllegalArgumentException e) {
                result = null;
            }
            if (result != null) {
                m_images.put(path, result);
            }
        }
        return result;
    }

    public static Font loadFont(String path, float size) {
        Class<?> c = null;
        URL url = null;
        String p = "net/sourceforge/jocular/resources/" + path;
        c = path.getClass();
        if (c != null) {
            url = c.getResource(p);
        }
        Font f = new Font("Serif", 0, 10).deriveFont(size);
        try {
            URLConnection connection = url.openConnection();
            InputStream in = connection.getInputStream();
            f = Font.createFont(0, in).deriveFont(size);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(f);
            in.close();
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return f;
    }

    public static Clip loadAudioClip(String path) {
        Clip result = null;
        Class<?> c = null;
        URL url = null;
        String p = "net/sourceforge/jocular/resources/" + path;
        c = path.getClass();
        if (c != null) {
            url = c.getResource(p);
        }
        try {
            URLConnection connection = url.openConnection();
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            AudioInputStream ais = AudioSystem.getAudioInputStream(in);
            result = AudioSystem.getClip();
            result.open(ais);
            ais.close();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Icon loadImageIcon(String s) {
        BufferedImage bi = ResourceTools.loadImage(s);
        ImageIcon result = null;
        if (bi != null) {
            result = new ImageIcon(bi);
        }
        return result;
    }

    public static String loadText(String path) {
        Class<?> c = null;
        URL url = null;
        String p = "net/sourceforge/jocular/resources/" + path;
        c = path.getClass();
        String result = "";
        if (c != null) {
            url = c.getResource(p);
        }
        try {
            URLConnection connection = url.openConnection();
            InputStream in = connection.getInputStream();
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            while (br.ready()) {
                sb.append(br.readLine());
            }
            result = sb.toString();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static URL getUrl(String path) {
        URL result = null;
        String p = "net/sourceforge/jocular/resources/" + path;
        result = p.getClass().getResource(p);
        return result;
    }

    public static void setFonts() {
        Font f = PARENT_FONT;
        f = f.deriveFont(12.0f);
        UIManager.put("Button.font", f);
        UIManager.put("CheckBox.font", f);
        UIManager.put("CheckBoxMenuItem.acceleratorFont", f);
        UIManager.put("CheckBoxMenuItem.font", f);
        UIManager.put("ColorChooser.font", f);
        UIManager.put("ComboBox.font", f);
        UIManager.put("EditorPane.font", f);
        UIManager.put("FormattedTextField.font", f);
        UIManager.put("IconButton.font", f);
        UIManager.put("InternalFrame.optionDialogTitleFont", f);
        UIManager.put("InternalFrame.paletteTitleFont", f);
        UIManager.put("InternalFrame.titleFont", f);
        UIManager.put("Label.font", f);
        UIManager.put("List.font", f);
        UIManager.put("Menu.acceleratorFont", f);
        UIManager.put("Menu.font", f);
        UIManager.put("MenuBar.font", f);
        UIManager.put("MenuItem.font", f);
        UIManager.put("OptionPane.font", f);
        UIManager.put("Panel.font", f);
        UIManager.put("PopupMenu.font", f);
        UIManager.put("ProgressBar.font", f);
        UIManager.put("RadioButton.font", f);
        UIManager.put("RadioButtonMenuItem.font", f);
        UIManager.put("ScrollPane.font", f);
        UIManager.put("ScrollBar.width", 20);
        UIManager.put("Slider.font", f);
        UIManager.put("Spinner.font", f);
        UIManager.put("TabbedPane.font", f);
        UIManager.put("Table.font", f);
        UIManager.put("TableHeader.font", f);
        UIManager.put("TextArea.font", f);
        UIManager.put("TextField.font", f);
        UIManager.put("TextPane.font", f);
        UIManager.put("TitledBorder.font", f);
        UIManager.put("ToggleButton.font", f);
        UIManager.put("ToolBar.font", f);
        UIManager.put("ToolTip.font", f);
        UIManager.put("Tree.font", f);
        UIManager.put("Viewport.font", f);
    }
}

