/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.util;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public abstract class BackgroundRunner<E> {
    private int m_lastProgress = 0;
    private E m_result = null;

    public E getResult() {
        return this.m_result;
    }

    public abstract E doTask(ProgressListener var1);

    public E execute(Frame owner, String startingMessage) {
        final JProgressBar bar = new JProgressBar(0, 100);
        Box panel = new Box(1);
        final JTextArea label = new JTextArea(startingMessage);
        label.setEditable(false);
        label.setPreferredSize(new Dimension(400, 250));
        final JButton button = new JButton("Cancel");
        bar.setValue(0);
        panel.add(label);
        panel.add(bar);
        panel.add(button);
        JDialog dialog = new JDialog(owner, true);
        dialog.setSize(new Dimension(400, 300));
        Point p = owner.getLocation();
        dialog.setLocation(p.x + 100, p.y + 100);
        dialog.add(panel);
        SwingWorker sw = new SwingWorker<E, Object>(){

            @Override
            protected E doInBackground() throws Exception {
                BackgroundRunner.this.m_result = BackgroundRunner.this.doTask((progress, message) -> {
                    int p = (int)(progress * 100.0);
                    if (p > BackgroundRunner.this.m_lastProgress + 1 || p == 100) {
                        BackgroundRunner.this.m_lastProgress = p;
                        this.setProgress(p);
                        SwingUtilities.invokeLater(() -> {
                            bar.setValue(p);
                            label.setText(message);
                        });
                    }
                });
                return BackgroundRunner.this.getResult();
            }

            @Override
            protected void done() {
                button.setText("Ok");
            }
        };
        button.addActionListener(e -> {
            if (button.getText().equals("Ok")) {
                dialog.dispose();
            } else {
                sw.cancel(true);
                dialog.dispose();
            }
        });
        sw.execute();
        dialog.setVisible(true);
        dialog.dispose();
        return this.getResult();
    }

    public static interface ProgressListener {
        public void setProgress(double var1, String var3);
    }
}

