/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.project.ProjectUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.undo.OpticsEdit;

public class PropertyEdit
extends OpticsEdit {
    private final PropertyKey m_key;
    private final PropertyOwner m_owner;
    private final String m_value;
    private final String m_oldValue;

    public PropertyEdit(OpticsProject p, PropertyOwner o, PropertyKey k, String v) {
        super(p);
        this.m_key = k;
        this.m_value = v;
        this.m_owner = o;
        this.m_oldValue = this.m_owner.getProperty(this.m_key).getDefiningString();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.m_owner.setProperty(this.m_key, this.m_value);
        if (this.m_owner instanceof OpticsObject) {
            OpticsObject o = (OpticsObject)this.m_owner;
            OpticsObject[] path = this.getProject().getPath(o);
            OpticsObjectGroup g = null;
            int pos = 0;
            if (path.length >= 2) {
                OpticsObject og = path[path.length - 2];
                g = (OpticsObjectGroup)og;
                g.getPos(o);
                this.getProject().fireNodeUpdate(o, g, OpticsProject.NodeUpdateType.CHANGE, pos);
            }
        }
        this.m_project.fireProjectUpdated(this.getUpdateType());
        this.m_owner.doInternalCalcs();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.m_owner.setProperty(this.m_key, this.m_oldValue);
        this.m_project.fireProjectUpdated(this.getUpdateType());
        this.m_owner.doInternalCalcs();
    }

    private ProjectUpdatedEvent getUpdateType() {
        if (this.m_owner instanceof OpticsObject) {
            OpticsObject o = (OpticsObject)this.m_owner;
            return new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.CHANGE, o);
        }
        if (this.m_owner instanceof ObjectPositioner) {
            return new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.POSITION);
        }
        return new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.NONE);
    }
}

