/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.positioners.ObjectPositionerKey;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.project.ProjectUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.undo.OpticsEdit;

public class PositionerEdit
extends OpticsEdit {
    private final OpticsObject m_object;
    private final ObjectPositioner m_newPos;
    private final ObjectPositioner m_oldPos;

    public PositionerEdit(OpticsObject o, ObjectPositionerKey newPosKey, OpticsProject p) {
        super(p);
        this.m_object = o;
        this.m_oldPos = o.getPositioner();
        this.m_newPos = newPosKey.getNewPositioner();
        for (PropertyKey k : this.m_newPos.getPropertyKeys()) {
            this.m_newPos.copyProperty(this.m_oldPos, k);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.m_object.setPositioner(this.m_newPos);
        super.redo();
        OpticsObject[] path = this.getProject().getPath(this.m_object);
        OpticsObject og = path[path.length - 2];
        OpticsObjectGroup g = (OpticsObjectGroup)og;
        this.getProject().fireNodeUpdate(this.m_object, g, OpticsProject.NodeUpdateType.CHANGE, g.getPos(this.m_object));
        this.getProject().fireProjectUpdated(new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.POSITION, this.m_object));
    }

    @Override
    public void undo() throws CannotUndoException {
        this.m_object.setPositioner(this.m_oldPos);
        super.undo();
        OpticsObject[] path = this.getProject().getPath(this.m_object);
        OpticsObject og = path[path.length - 2];
        OpticsObjectGroup g = (OpticsObjectGroup)og;
        this.getProject().fireNodeUpdate(this.m_object, g, OpticsProject.NodeUpdateType.CHANGE, g.getPos(this.m_object));
        this.getProject().fireProjectUpdated(new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.POSITION, this.m_object));
    }
}

