/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.project.ProjectUpdatedEvent;
import net.sourceforge.jocular.undo.OpticsEdit;

public class OpticsObjectEdit
extends OpticsEdit {
    private final OpticsObjectGroup m_group;
    private final OpticsObject m_newObject;
    private final OpticsObject m_oldObject;
    private final int m_addPos;
    private final int m_removePos;

    public OpticsObjectEdit(OpticsObjectGroup group, OpticsObject newObject, int pos, OpticsObject oldObject, OpticsProject project) {
        super(project);
        OpticsObjectGroup g1 = project.getOpticsObject();
        int count = project.getChildCount(g1);
        if (count != 0) {
            g1 = group;
        }
        if (g1 == null) {
            throw new RuntimeException("Group cannot be null.");
        }
        this.m_group = g1;
        this.m_oldObject = oldObject;
        this.m_newObject = newObject;
        this.m_addPos = pos;
        this.m_removePos = this.m_oldObject != null ? this.m_group.getPos(this.m_oldObject) : -1;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.m_newObject != null) {
            this.m_group.add(this.m_newObject, this.m_addPos);
            this.getProject().fireNodeUpdate(this.m_newObject, this.m_group, OpticsProject.NodeUpdateType.ADD, this.m_addPos);
            this.getProject().fireProjectUpdated(new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.ADD, this.m_newObject));
            this.getProject().getOpticsObject().doInternalCalcs();
        }
        if (this.m_oldObject != null) {
            this.m_group.remove(this.m_oldObject);
            this.getProject().fireNodeUpdate(this.m_oldObject, this.m_group, OpticsProject.NodeUpdateType.REMOVE, this.m_removePos);
            this.getProject().fireProjectUpdated(new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.REMOVE, this.m_oldObject));
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.m_newObject != null) {
            this.m_group.remove(this.m_newObject);
            this.getProject().fireNodeUpdate(this.m_newObject, this.m_group, OpticsProject.NodeUpdateType.REMOVE, this.m_addPos);
            this.getProject().fireProjectUpdated(new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.REMOVE, this.m_newObject));
        }
        if (this.m_oldObject != null) {
            this.m_group.add(this.m_oldObject, this.m_removePos);
            this.getProject().fireNodeUpdate(this.m_oldObject, this.m_group, OpticsProject.NodeUpdateType.ADD, this.m_removePos);
            this.getProject().fireProjectUpdated(new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.ADD, this.m_oldObject));
            this.getProject().getOpticsObject().doInternalCalcs();
        }
    }
}

