/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.undo.OpticsEdit;

public class OpticsMoveEdit
extends OpticsEdit {
    OpticsProject m_project;
    OpticsObjectGroup m_group;
    OpticsObject m_object;
    boolean m_upNotDown;
    int m_oldLoc;
    int m_newLoc;

    public OpticsMoveEdit(OpticsProject p, OpticsObjectGroup g, OpticsObject o, boolean upNotDown) {
        super(p);
        this.m_project = p;
        this.m_group = g;
        this.m_object = o;
        this.m_upNotDown = upNotDown;
        this.m_oldLoc = this.m_group.getPos(this.m_object);
        this.m_newLoc = upNotDown ? (this.m_oldLoc > 0 ? this.m_oldLoc - 1 : this.m_oldLoc) : (this.m_oldLoc < this.m_group.getObjects().size() - 1 ? this.m_oldLoc + 1 : this.m_oldLoc);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.m_oldLoc != this.m_newLoc) {
            this.m_group.remove(this.m_object);
            this.m_group.add(this.m_object, this.m_newLoc);
            this.getProject().fireNodeUpdate(this.m_object, this.m_group, OpticsProject.NodeUpdateType.REMOVE, this.m_oldLoc);
            this.getProject().fireNodeUpdate(this.m_object, this.m_group, OpticsProject.NodeUpdateType.ADD, this.m_newLoc);
        } else {
            System.out.println("OpticsMoveObject.redo new location equals old location.");
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.m_oldLoc != this.m_newLoc) {
            this.m_group.remove(this.m_object);
            this.m_group.add(this.m_object, this.m_oldLoc);
            this.getProject().fireNodeUpdate(this.m_object, this.m_group, OpticsProject.NodeUpdateType.REMOVE, this.m_newLoc);
            this.getProject().fireNodeUpdate(this.m_object, this.m_group, OpticsProject.NodeUpdateType.ADD, this.m_oldLoc);
        } else {
            System.out.println("OpticsMoveObject.undo old location equals new location.");
        }
    }
}

