/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.splines;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.ArrayProperty;
import net.sourceforge.jocular.properties.EnumArrayProperty;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.splines.RotatedSpline;
import net.sourceforge.jocular.splines.SplineObject;

public class SplinePointTableModel
implements TableModel {
    private final SplineObject m_object;
    protected static final int INDEX_COLUMN = 0;
    protected static final int INDEP_VAR_COLUMN = 1;
    protected static final int DEP_VAR_COLUMN = 2;
    protected static final int POINT_TYPE_COLUMN = 3;
    private final OpticsProject m_project;
    private List<TableModelListener> m_listeners = new CopyOnWriteArrayList<TableModelListener>();

    public SplinePointTableModel(SplineObject so, OpticsProject project) {
        this.m_project = project;
        this.m_object = so;
        this.m_object.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                SplinePointTableModel.this.fireTableUpdate();
            }
        });
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public Class<?> getColumnClass(int col) {
        Class result = null;
        switch (col) {
            case 0: {
                result = Integer.class;
                break;
            }
            case 1: 
            case 2: {
                result = EquationArrayProperty.class;
                break;
            }
            case 3: {
                result = EnumArrayProperty.class;
                break;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        String result = null;
        switch (col) {
            case 0: {
                result = "Index";
                break;
            }
            case 2: {
                if (this.m_object instanceof RotatedSpline) {
                    result = "Radius";
                    break;
                }
                result = "Y";
                break;
            }
            case 1: {
                if (this.m_object instanceof RotatedSpline) {
                    result = "Z";
                    break;
                }
                result = "X";
                break;
            }
            case 3: {
                result = "Point Type";
                break;
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        EquationArrayProperty eap = (EquationArrayProperty)this.m_object.getProperty(PropertyKey.POINTS_X);
        return eap.getValue().length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Property<?> result = null;
        switch (col) {
            case 0: {
                result = row;
                break;
            }
            case 1: {
                result = this.m_object.getProperty(PropertyKey.POINTS_X);
                break;
            }
            case 2: {
                result = this.m_object.getProperty(PropertyKey.POINTS_Y);
                break;
            }
            case 3: {
                result = this.m_object.getProperty(PropertyKey.POINTS_TYPES);
                break;
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fireTableUpdate() {
        TableModelEvent e = new TableModelEvent(this);
        for (TableModelListener l : this.m_listeners) {
            l.tableChanged(e);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (!(value instanceof String[])) {
            return;
        }
        String[] ss = (String[])value;
        Object s = "";
        for (String ts : ss) {
            s = (String)s + "\"" + ts + "\",";
        }
        System.out.println("SplinePointTableModel.setValueAt " + (String)s);
        switch (col) {
            case 1: {
                PropertyKey key = PropertyKey.POINTS_X;
                ArrayProperty eap = new EquationArrayProperty(ss, (PropertyOwner)this.m_object, key);
                this.m_project.addPropertyEdit(this.m_object, key, eap.getDefiningString());
                break;
            }
            case 2: {
                PropertyKey key = PropertyKey.POINTS_Y;
                ArrayProperty eap = new EquationArrayProperty(ss, (PropertyOwner)this.m_object, key);
                this.m_project.addPropertyEdit(this.m_object, key, eap.getDefiningString());
                break;
            }
            case 3: {
                PropertyKey key = PropertyKey.POINTS_TYPES;
                ArrayProperty eap = new EnumArrayProperty(SplineObject.PointType.values()[0], ss);
                this.m_project.addPropertyEdit(this.m_object, key, eap.getDefiningString());
                System.out.println("SplinePointTableModel.setValueAt \"" + eap.getDefiningString() + "\"");
                break;
            }
        }
    }
}

