/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.splines;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jocular.actions.OpticsAction;
import net.sourceforge.jocular.graphs.GraphPanel;
import net.sourceforge.jocular.gui.EquationField;
import net.sourceforge.jocular.math.Complex;
import net.sourceforge.jocular.math.PolygonDicer;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.ArrayProperty;
import net.sourceforge.jocular.properties.EnumArrayProperty;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.splines.SplineObject;
import net.sourceforge.jocular.splines.SplinePointCellEditor;
import net.sourceforge.jocular.splines.SplinePointTableModel;
import net.sourceforge.jocular.splines.SplineTableCellRenderer;
import net.sourceforge.jocular.undo.MultiEdit;
import net.sourceforge.jocular.undo.OpticsEdit;
import net.sourceforge.jocular.undo.PropertyEdit;

public class SplinePointDialog
extends JDialog {
    protected static final String SPLINE_SERIES = "Spline";
    protected static final String POINT_SERIES = "Points";
    protected static final String SELECTED_POINT_SERIES = "Selected Point";
    protected static final String SPLINE_POINT_SERIES = "Spline Points";
    private OpticsProject m_project;
    private GraphPanel m_graph;
    private JTable m_table;
    private SplineObject m_object;
    private EquationField m_simplifyField;

    public SplinePointDialog(Frame owner, OpticsProject project, SplineObject object) {
        super(owner, "Edit Spline Points");
        this.setLayout(new BorderLayout());
        this.m_project = project;
        this.m_object = object;
        this.m_object.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                SplinePointDialog.this.updateGraph();
            }
        });
        this.m_simplifyField = new EquationField(object, PropertyKey.SIMPLIFY_THRESHOLD, this.m_project);
        this.m_graph = new GraphPanel();
        this.m_graph.setGraphType(GraphPanel.GraphType.XY_DOT);
        this.m_graph.autoScale(true, false, true, false);
        this.m_graph.setPreferredSize(new Dimension(400, 400));
        this.setSize(new Dimension(500, 400));
        Box b = Box.createVerticalBox();
        b.add(this.m_graph);
        this.m_table = new JTable(new SplinePointTableModel(this.m_object, this.m_project));
        SplineTableCellRenderer stcr = new SplineTableCellRenderer();
        SplinePointCellEditor stce = new SplinePointCellEditor();
        this.m_table.setDefaultRenderer(EnumArrayProperty.class, stcr);
        this.m_table.setDefaultRenderer(EquationArrayProperty.class, stcr);
        this.m_table.setDefaultEditor(EnumArrayProperty.class, stce);
        this.m_table.setDefaultEditor(EquationArrayProperty.class, stce);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                Point p = e.getPoint();
                int r = SplinePointDialog.this.m_table.rowAtPoint(p);
                SplinePointDialog.this.m_table.getSelectionModel().setSelectionInterval(r, r);
            }
        });
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SplinePointDialog.this.m_table.isEditing()) {
                    SplinePointDialog.this.m_table.getCellEditor().stopCellEditing();
                }
                SplinePointDialog.this.updateGraph();
            }
        });
        b.add(new JScrollPane(this.m_table));
        Box p5 = Box.createHorizontalBox();
        p5.add(new JLabel("Simplify Threshold"));
        p5.add(this.m_simplifyField);
        b.add(p5);
        JToolBar jtb = new JToolBar();
        jtb.setFloatable(false);
        jtb.add(OpticsAction.SPLINE_ADD);
        jtb.add(OpticsAction.SPLINE_REMOVE);
        jtb.add(OpticsAction.SPLINE_PASTE);
        jtb.add(OpticsAction.SPLINE_CLOSE);
        this.add((Component)jtb, "North");
        this.add((Component)b, "Center");
        this.updateGraph();
    }

    public void deleteRow() {
        int i = this.m_table.getSelectedRow();
        if (i < 0) {
            JOptionPane.showMessageDialog(this, "Must select row in order to delete.");
        } else {
            this.m_project.addAndDoEdit(new MultiEdit(this.m_project, new OpticsEdit[]{new PropertyEdit(this.m_project, this.m_object, PropertyKey.POINTS_X, ((EquationArrayProperty)this.m_object.getProperty(PropertyKey.POINTS_X)).removeRowFromDefiningString(i)), new PropertyEdit(this.m_project, this.m_object, PropertyKey.POINTS_Y, ((EquationArrayProperty)this.m_object.getProperty(PropertyKey.POINTS_Y)).removeRowFromDefiningString(i)), new PropertyEdit(this.m_project, this.m_object, PropertyKey.POINTS_TYPES, ((ArrayProperty)this.m_object.getProperty(PropertyKey.POINTS_TYPES)).removeRowFromDefiningString(i))}));
        }
    }

    public void addRow() {
        int i = this.m_table.getSelectedRow();
        if (i < 0) {
            i = this.m_object.getSplinePointCount();
        }
        this.m_project.addAndDoEdit(new MultiEdit(this.m_project, new OpticsEdit[]{new PropertyEdit(this.m_project, this.m_object, PropertyKey.POINTS_X, ((EquationArrayProperty)this.m_object.getProperty(PropertyKey.POINTS_X)).addRowToDefiningString(i)), new PropertyEdit(this.m_project, this.m_object, PropertyKey.POINTS_Y, ((EquationArrayProperty)this.m_object.getProperty(PropertyKey.POINTS_Y)).addRowToDefiningString(i)), new PropertyEdit(this.m_project, this.m_object, PropertyKey.POINTS_TYPES, ((EnumArrayProperty)this.m_object.getProperty(PropertyKey.POINTS_TYPES)).addRowToDefiningString(i))}));
    }

    public void getTableFromClipboard() {
        String ts = "";
        boolean failed = false;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            if (contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                ts = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            failed = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            failed = true;
        }
        String[][] table = null;
        if (!failed) {
            String[] rows = ts.split("\n");
            table = new String[3][rows.length];
            int r = 0;
            while (r < rows.length) {
                String[] cs = rows[r].split("\t");
                if (cs.length == 1) {
                    cs = rows[r].split(",");
                }
                if (cs.length < 2) {
                    failed = true;
                    break;
                }
                table[0][r] = cs[0];
                table[1][r] = cs[1];
                table[2][r] = cs.length < 3 ? "CUSP" : cs[2].toUpperCase();
                ++r;
            }
        }
        if (!failed) {
            this.m_project.addAndDoEdit(new MultiEdit(this.m_project, new OpticsEdit[]{new PropertyEdit(this.m_project, this.m_object, PropertyKey.POINTS_X, new EquationArrayProperty(table[0], (PropertyOwner)this.m_object, PropertyKey.POINTS_X).getDefiningString()), new PropertyEdit(this.m_project, this.m_object, PropertyKey.POINTS_Y, new EquationArrayProperty(table[1], (PropertyOwner)this.m_object, PropertyKey.POINTS_X).getDefiningString()), new PropertyEdit(this.m_project, this.m_object, PropertyKey.POINTS_TYPES, new EnumArrayProperty(SplineObject.PointType.CUSP, table[2]).getDefiningString())}));
        }
        if (failed) {
            JOptionPane.showMessageDialog(this, "Wrong clipboard contents.\n Need tab separated text with three columns.\n Each row should be: X, Y, [CUSP/ SMOOTH/ SQUARE]");
        }
    }

    protected void updateGraph() {
        double[] xs = this.m_object.getSplinePointIndepValues();
        double[] ys = this.m_object.getSplinePointDepValues();
        this.m_graph.updateGraph(POINT_SERIES, xs, ys);
        this.m_graph.setSeriesSize(POINT_SERIES, 5.0, 1.0);
        this.m_graph.setSeriesType(POINT_SERIES, GraphPanel.GraphType.XY_DOT);
        this.m_graph.setSeriesDotType(POINT_SERIES, GraphPanel.DotType.CIRCLE);
        this.m_graph.setSeriesColor(POINT_SERIES, Color.GREEN);
        PolygonDicer d = new PolygonDicer(this.m_object.getSplineCoefficients(), 40);
        this.m_graph.updateGraph(SPLINE_SERIES, d.getXs(), d.getYs());
        this.m_graph.setSeriesSize(SPLINE_SERIES, 5.0, 1.0);
        this.m_graph.setSeriesType(SPLINE_SERIES, GraphPanel.GraphType.XY_CONTINUOUS);
        this.m_graph.setSeriesColor(SPLINE_SERIES, Color.RED);
        double[][] pts = this.getSelectedPoints();
        this.m_graph.updateGraph(SELECTED_POINT_SERIES, pts[0], pts[1]);
        this.m_graph.setSeriesColor(SELECTED_POINT_SERIES, Color.MAGENTA);
        this.m_graph.setSeriesType(SELECTED_POINT_SERIES, GraphPanel.GraphType.XY_DOT);
        this.m_graph.setSeriesDotType(SELECTED_POINT_SERIES, GraphPanel.DotType.SQUARE);
        this.m_graph.setSeriesSize(SELECTED_POINT_SERIES, 10.0, 10.0);
        this.m_graph.autoScale(true, false, true, false);
        this.m_graph.repaint();
    }

    private double[][] getSelectedPoints() {
        int[] sr = this.m_table.getSelectedRows();
        int n = sr.length;
        ArrayList<Complex> cs = new ArrayList<Complex>();
        EquationArrayProperty ex = (EquationArrayProperty)this.m_object.getProperty(PropertyKey.POINTS_X);
        EquationArrayProperty ey = (EquationArrayProperty)this.m_object.getProperty(PropertyKey.POINTS_Y);
        int i = 0;
        while (i < n) {
            int j = sr[i];
            if (j < this.m_table.getRowCount()) {
                cs.add(new Complex(ex.getValue()[j].getBaseUnitValue(), ey.getValue()[j].getBaseUnitValue()));
            }
            ++i;
        }
        double[][] result = new double[2][cs.size()];
        int i2 = 0;
        while (i2 < cs.size()) {
            Complex c = (Complex)cs.get(i2);
            result[0][i2] = c.real();
            result[1][i2] = c.imag();
            ++i2;
        }
        return result;
    }
}

