/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.splines;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import net.sourceforge.jocular.properties.ArrayProperty;
import net.sourceforge.jocular.properties.EnumArrayProperty;
import net.sourceforge.jocular.splines.SplineObject;

public class SplinePointCellEditor
implements TableCellEditor {
    private List<CellEditorListener> m_listeners = new CopyOnWriteArrayList<CellEditorListener>();
    String[] m_definingStrings = new String[0];
    int m_indexEditing = 0;
    int m_editingColumn = 0;
    protected static final String POSITIONER_SUFFIX = " - Pos";
    JComboBox<SplineObject.PointType> m_pointTypeCombo = new JComboBox<SplineObject.PointType>(SplineObject.PointType.values());
    JTextField m_textField = new JTextField();

    public SplinePointCellEditor() {
        this.m_pointTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SplinePointCellEditor.this.fireEditingStopped();
            }
        });
        this.m_textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SplinePointCellEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCancelled();
    }

    @Override
    public Object getCellEditorValue() {
        System.out.println("SplinePointCellEditor.getCellEditorValue!!!");
        switch (this.m_editingColumn) {
            case 1: {
                this.m_definingStrings[this.m_indexEditing] = this.m_textField.getText();
                break;
            }
            case 2: {
                this.m_definingStrings[this.m_indexEditing] = this.m_textField.getText();
                break;
            }
            case 3: {
                this.m_definingStrings[this.m_indexEditing] = this.m_pointTypeCombo.getItemAt(this.m_pointTypeCombo.getSelectedIndex()).name();
                System.out.println("SplinePointCellEditor.getCellEditorValue " + this.m_definingStrings[this.m_indexEditing]);
                break;
            }
        }
        return this.m_definingStrings;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComponent result = null;
        this.m_definingStrings = ((ArrayProperty)value).getDefiningStrings();
        this.m_indexEditing = row;
        this.m_editingColumn = column;
        switch (column) {
            case 1: {
                this.m_textField.setText(this.m_definingStrings[row]);
                result = this.m_textField;
                break;
            }
            case 2: {
                this.m_textField.setText(this.m_definingStrings[row]);
                result = this.m_textField;
                break;
            }
            case 3: {
                this.m_pointTypeCombo.setSelectedItem(((EnumArrayProperty)value).getValue()[row]);
                result = this.m_pointTypeCombo;
                break;
            }
        }
        return result;
    }

    private void fireEditingStopped() {
        for (CellEditorListener ce : this.m_listeners) {
            ce.editingStopped(new ChangeEvent(this));
        }
    }

    private void fireEditingCancelled() {
        for (CellEditorListener ce : this.m_listeners) {
            ce.editingStopped(new ChangeEvent(this));
        }
    }
}

