/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.splines;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jocular.splines.SplineCoefficients;
import net.sourceforge.jocular.splines.SplineObject;

public class SplineMath {
    private static Matrix fit(double[] xs, double[] ys, EndPointType pt0, EndPointType ptn) {
        int splineNum;
        boolean closedCurve;
        EndPointType apt0 = pt0;
        EndPointType aptn = ptn;
        boolean bl = closedCurve = apt0 == EndPointType.SMOOTH || ptn == EndPointType.SMOOTH;
        if (xs.length != ys.length) {
            throw new RuntimeException("X and Y data lengths are not equal: " + xs.length + ", " + ys.length);
        }
        if (xs.length < 2) {
            throw new RuntimeException("There must be at least 2 points to compute the spline. There is only " + xs.length + " point to fit.");
        }
        boolean linearOrQuadratic = false;
        if (closedCurve) {
            splineNum = xs.length;
        } else if (apt0 == EndPointType.CUSP && aptn == EndPointType.CUSP && xs.length <= 3) {
            splineNum = 1;
            linearOrQuadratic = true;
        } else {
            splineNum = xs.length - 1;
        }
        int n = splineNum;
        int m = n *= 8;
        Matrix a = new Matrix(m, n, 0.0);
        Matrix c = new Matrix(m, 1, 0.0);
        int r = 0;
        if (linearOrQuadratic) {
            if (xs.length == 2) {
                c.set(2, 0, xs[0]);
                c.set(3, 0, xs[1]);
                c.set(6, 0, ys[0]);
                c.set(7, 0, ys[1]);
                a.set(0, 0, 1.0);
                a.set(1, 1, 1.0);
                a.set(2, 3, 1.0);
                a.set(3, 2, 1.0);
                a.set(3, 3, 1.0);
                a.set(4, 4, 1.0);
                a.set(5, 5, 1.0);
                a.set(6, 7, 1.0);
                a.set(7, 6, 1.0);
                a.set(7, 7, 1.0);
            } else {
                c.set(1, 0, xs[0]);
                c.set(2, 0, xs[1]);
                c.set(3, 0, xs[2]);
                c.set(5, 0, ys[0]);
                c.set(6, 0, ys[1]);
                c.set(7, 0, ys[2]);
                a.set(0, 0, 1.0);
                a.set(1, 3, 1.0);
                a.set(2, 1, 0.25);
                a.set(2, 2, 0.5);
                a.set(2, 3, 1.0);
                a.set(3, 1, 1.0);
                a.set(3, 2, 1.0);
                a.set(3, 3, 1.0);
                a.set(4, 4, 1.0);
                a.set(5, 7, 1.0);
                a.set(6, 5, 0.25);
                a.set(6, 6, 0.5);
                a.set(6, 7, 1.0);
                a.set(7, 5, 1.0);
                a.set(7, 6, 1.0);
                a.set(7, 7, 1.0);
            }
        } else {
            for (int i = 0; i < splineNum; ++i) {
                c.set(r, 0, xs[i]);
                a.set(r, i * 8 + 0, 0.0);
                a.set(r, i * 8 + 1, 0.0);
                a.set(r, i * 8 + 2, 0.0);
                a.set(r, i * 8 + 3, 1.0);
                c.set(++r, 0, ys[i]);
                a.set(r, i * 8 + 4, 0.0);
                a.set(r, i * 8 + 5, 0.0);
                a.set(r, i * 8 + 6, 0.0);
                a.set(r, i * 8 + 7, 1.0);
                ++r;
                int in = i + 1;
                if (in >= xs.length) {
                    in = 0;
                }
                c.set(r, 0, xs[in]);
                a.set(r, i * 8 + 0, 1.0);
                a.set(r, i * 8 + 1, 1.0);
                a.set(r, i * 8 + 2, 1.0);
                a.set(r, i * 8 + 3, 1.0);
                c.set(++r, 0, ys[in]);
                a.set(r, i * 8 + 4, 1.0);
                a.set(r, i * 8 + 5, 1.0);
                a.set(r, i * 8 + 6, 1.0);
                a.set(r, i * 8 + 7, 1.0);
                ++r;
                if (i < splineNum - 1) {
                    c.set(r, 0, 0.0);
                    a.set(r, (i + 0) * 8 + 0, 3.0);
                    a.set(r, (i + 0) * 8 + 1, 2.0);
                    a.set(r, (i + 0) * 8 + 2, 1.0);
                    a.set(r, (i + 0) * 8 + 3, 0.0);
                    a.set(r, (i + 1) * 8 + 0, -0.0);
                    a.set(r, (i + 1) * 8 + 1, -0.0);
                    a.set(r, (i + 1) * 8 + 2, -1.0);
                    a.set(r, (i + 1) * 8 + 3, -0.0);
                    c.set(++r, 0, 0.0);
                    a.set(r, (i + 0) * 8 + 4, 3.0);
                    a.set(r, (i + 0) * 8 + 5, 2.0);
                    a.set(r, (i + 0) * 8 + 6, 1.0);
                    a.set(r, (i + 0) * 8 + 7, 0.0);
                    a.set(r, (i + 1) * 8 + 4, -0.0);
                    a.set(r, (i + 1) * 8 + 5, -0.0);
                    a.set(r, (i + 1) * 8 + 6, -1.0);
                    a.set(r, (i + 1) * 8 + 7, -0.0);
                    c.set(++r, 0, 0.0);
                    a.set(r, (i + 0) * 8 + 0, 6.0);
                    a.set(r, (i + 0) * 8 + 1, 2.0);
                    a.set(r, (i + 0) * 8 + 2, 0.0);
                    a.set(r, (i + 0) * 8 + 3, 0.0);
                    a.set(r, (i + 1) * 8 + 0, -0.0);
                    a.set(r, (i + 1) * 8 + 1, -2.0);
                    a.set(r, (i + 1) * 8 + 2, -0.0);
                    a.set(r, (i + 1) * 8 + 3, -0.0);
                    c.set(++r, 0, 0.0);
                    a.set(r, (i + 0) * 8 + 4, 6.0);
                    a.set(r, (i + 0) * 8 + 5, 2.0);
                    a.set(r, (i + 0) * 8 + 6, 0.0);
                    a.set(r, (i + 0) * 8 + 7, 0.0);
                    a.set(r, (i + 1) * 8 + 4, -0.0);
                    a.set(r, (i + 1) * 8 + 5, -2.0);
                    a.set(r, (i + 1) * 8 + 6, -0.0);
                    a.set(r, (i + 1) * 8 + 7, -0.0);
                    ++r;
                    continue;
                }
                if (!closedCurve) continue;
                c.set(r, 0, 0.0);
                a.set(r, (i + 0) * 8 + 0, 3.0);
                a.set(r, (i + 0) * 8 + 1, 2.0);
                a.set(r, (i + 0) * 8 + 2, 1.0);
                a.set(r, (i + 0) * 8 + 3, 0.0);
                a.set(r, 0, -0.0);
                a.set(r, 1, -0.0);
                a.set(r, 2, -1.0);
                a.set(r, 3, -0.0);
                c.set(++r, 0, 0.0);
                a.set(r, (i + 0) * 8 + 4, 3.0);
                a.set(r, (i + 0) * 8 + 5, 2.0);
                a.set(r, (i + 0) * 8 + 6, 1.0);
                a.set(r, (i + 0) * 8 + 7, 0.0);
                a.set(r, 4, -0.0);
                a.set(r, 5, -0.0);
                a.set(r, 6, -1.0);
                a.set(r, 7, -0.0);
                c.set(++r, 0, 0.0);
                a.set(r, (i + 0) * 8 + 0, 6.0);
                a.set(r, (i + 0) * 8 + 1, 2.0);
                a.set(r, (i + 0) * 8 + 2, 0.0);
                a.set(r, (i + 0) * 8 + 3, 0.0);
                a.set(r, 0, -0.0);
                a.set(r, 1, -2.0);
                a.set(r, 2, -0.0);
                a.set(r, 3, -0.0);
                c.set(++r, 0, 0.0);
                a.set(r, (i + 0) * 8 + 4, 6.0);
                a.set(r, (i + 0) * 8 + 5, 2.0);
                a.set(r, (i + 0) * 8 + 6, 0.0);
                a.set(r, (i + 0) * 8 + 7, 0.0);
                a.set(r, 4, -0.0);
                a.set(r, 5, -2.0);
                a.set(r, 6, -0.0);
                a.set(r, 7, -0.0);
                ++r;
            }
            if (!closedCurve) {
                switch (aptn) {
                    case CUSP: {
                        if (splineNum == 1) {
                            c.set(r, 0, 0.0);
                            a.set(r, 0, 1.0);
                            c.set(++r, 0, 0.0);
                            a.set(r, 4, 1.0);
                            ++r;
                            break;
                        }
                        c.set(r, 0, 0.0);
                        a.set(r, (splineNum - 1) * 8 + 0, 6.0);
                        a.set(r, (splineNum - 1) * 8 + 1, 2.0);
                        a.set(r, (splineNum - 1) * 8 + 2, 0.0);
                        a.set(r, (splineNum - 1) * 8 + 3, 0.0);
                        a.set(r, (splineNum - 2) * 8 + 0, -12.0);
                        a.set(r, (splineNum - 2) * 8 + 1, -2.0);
                        a.set(r, (splineNum - 2) * 8 + 2, 0.0);
                        a.set(r, (splineNum - 2) * 8 + 3, 0.0);
                        c.set(++r, 0, 0.0);
                        a.set(r, (splineNum - 1) * 8 + 4, 6.0);
                        a.set(r, (splineNum - 1) * 8 + 5, 2.0);
                        a.set(r, (splineNum - 1) * 8 + 6, 0.0);
                        a.set(r, (splineNum - 1) * 8 + 7, 0.0);
                        a.set(r, (splineNum - 2) * 8 + 4, -12.0);
                        a.set(r, (splineNum - 2) * 8 + 5, -2.0);
                        a.set(r, (splineNum - 2) * 8 + 6, 0.0);
                        a.set(r, (splineNum - 2) * 8 + 7, 0.0);
                        ++r;
                        break;
                    }
                    case VERT: {
                        c.set(r, 0, 0.0);
                        a.set(r, (splineNum - 1) * 8 + 0, 3.0);
                        a.set(r, (splineNum - 1) * 8 + 1, 2.0);
                        a.set(r, (splineNum - 1) * 8 + 2, 1.0);
                        a.set(r, (splineNum - 1) * 8 + 3, 0.0);
                        c.set(++r, 0, 0.0);
                        a.set(r, (splineNum - 1) * 8 + 4, 6.0);
                        a.set(r, (splineNum - 1) * 8 + 5, 2.0);
                        a.set(r, (splineNum - 1) * 8 + 6, 0.0);
                        a.set(r, (splineNum - 1) * 8 + 7, 0.0);
                        ++r;
                        break;
                    }
                    case HORIZ: {
                        c.set(r, 0, 0.0);
                        a.set(r, (splineNum - 1) * 8 + 4, 3.0);
                        a.set(r, (splineNum - 1) * 8 + 5, 2.0);
                        a.set(r, (splineNum - 1) * 8 + 6, 1.0);
                        a.set(r, (splineNum - 1) * 8 + 7, 0.0);
                        c.set(++r, 0, 0.0);
                        a.set(r, (splineNum - 1) * 8 + 0, 6.0);
                        a.set(r, (splineNum - 1) * 8 + 1, 2.0);
                        a.set(r, (splineNum - 1) * 8 + 2, 0.0);
                        a.set(r, (splineNum - 1) * 8 + 3, 0.0);
                        ++r;
                        break;
                    }
                }
                switch (apt0) {
                    case CUSP: {
                        if (splineNum == 1) {
                            c.set(r, 0, 0.0);
                            a.set(r, 0, 1.0);
                            c.set(++r, 0, 0.0);
                            a.set(r, 4, 1.0);
                            ++r;
                            break;
                        }
                        c.set(r, 0, 0.0);
                        a.set(r, 0, 0.0);
                        a.set(r, 1, 2.0);
                        a.set(r, 2, 0.0);
                        a.set(r, 3, 0.0);
                        a.set(r, 8, 6.0);
                        a.set(r, 9, -2.0);
                        a.set(r, 10, 0.0);
                        a.set(r, 11, 0.0);
                        c.set(++r, 0, 0.0);
                        a.set(r, 4, 0.0);
                        a.set(r, 5, 2.0);
                        a.set(r, 6, 0.0);
                        a.set(r, 7, 0.0);
                        a.set(r, 12, 6.0);
                        a.set(r, 13, -2.0);
                        a.set(r, 14, 0.0);
                        a.set(r, 15, 0.0);
                        ++r;
                        break;
                    }
                    case VERT: {
                        c.set(r, 0, 0.0);
                        a.set(r, 0, 0.0);
                        a.set(r, 1, 0.0);
                        a.set(r, 2, 1.0);
                        a.set(r, 3, 0.0);
                        c.set(++r, 0, 0.0);
                        a.set(r, 4, 0.0);
                        a.set(r, 5, 2.0);
                        a.set(r, 6, 0.0);
                        a.set(r, 7, 0.0);
                        ++r;
                        break;
                    }
                    case HORIZ: {
                        c.set(r, 0, 0.0);
                        a.set(r, 4, 0.0);
                        a.set(r, 5, 0.0);
                        a.set(r, 6, 1.0);
                        a.set(r, 7, 0.0);
                        c.set(++r, 0, 0.0);
                        a.set(r, 0, 0.0);
                        a.set(r, 1, 2.0);
                        a.set(r, 2, 0.0);
                        a.set(r, 3, 0.0);
                        ++r;
                        break;
                    }
                }
            }
        }
        Matrix result = a.inverse().times(c);
        return result;
    }

    private static List<SplineCoefficients> approxFit(double[] xs, double[] ys, EndPointType pt0, EndPointType ptn, double error) {
        List<SplineCoefficients> result = new ArrayList<SplineCoefficients>();
        if (error == 0.0) {
            return SplineMath.convertCoefficients(SplineMath.fit(xs, ys, pt0, ptn));
        }
        EndPointType apt0 = pt0;
        EndPointType aptn = ptn;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        indexes.add(0);
        indexes.add(xs.length - 1);
        boolean done = false;
        block0: while (!done) {
            double[] nxs = new double[indexes.size()];
            double[] nys = new double[indexes.size()];
            int k = 0;
            for (Integer i : indexes) {
                nxs[k] = xs[i];
                nys[k] = ys[i];
                ++k;
            }
            result = SplineMath.convertCoefficients(SplineMath.fit(nxs, nys, apt0, aptn));
            double maxErrSq = 0.0;
            int maxErrIndex = -1;
            for (int i = 0; i < xs.length; ++i) {
                double minErrSq = Double.MAX_VALUE;
                for (int j = 0; j < result.size(); ++j) {
                    double ey;
                    double s;
                    SplineCoefficients sc = result.get(j);
                    double ex = sc.calcX(s = sc.bestFitParameter(xs[i], ys[i])) - xs[i];
                    double errSq = ex * ex + (ey = sc.calcY(s) - ys[i]) * ey;
                    if (errSq < minErrSq) {
                        minErrSq = errSq;
                        continue;
                    }
                    if (!Double.isNaN(errSq)) continue;
                    throw new RuntimeException("Err is NaN.");
                }
                if (!(maxErrSq < minErrSq)) continue;
                maxErrSq = minErrSq;
                if (maxErrSq == Double.MAX_VALUE) {
                    throw new RuntimeException("Somehow we're setting the maximum computed error to MAX_VALUE.");
                }
                maxErrIndex = i;
            }
            if (maxErrSq > error * error) {
                done = false;
                for (int j = 0; j < indexes.size(); ++j) {
                    if ((Integer)indexes.get(j) > maxErrIndex) {
                        indexes.add(j, maxErrIndex);
                        continue block0;
                    }
                    if ((Integer)indexes.get(j) != maxErrIndex) continue;
                    int m = j == 0 ? 0 : ((Integer)indexes.get(j - 1) + (Integer)indexes.get(j)) / 2;
                    indexes.add(j, m);
                    continue block0;
                }
                continue;
            }
            done = true;
        }
        return result;
    }

    private static SplineCoefficients[] fitWithOnlyStraightLines(SplineObject object) {
        double[] xs = object.getSplinePointIndepValues();
        double[] ys = object.getSplinePointDepValues();
        ArrayList<SplineCoefficients> result = new ArrayList<SplineCoefficients>();
        for (int i = 0; i < xs.length; ++i) {
            int j = (i + 1) % xs.length;
            double[] sxs = new double[2];
            double[] sys = new double[2];
            sxs[0] = xs[i];
            sys[0] = ys[i];
            sxs[1] = xs[j];
            sys[1] = ys[j];
            result.addAll(SplineMath.convertCoefficients(SplineMath.fit(sxs, sys, EndPointType.CUSP, EndPointType.CUSP)));
        }
        return result.toArray(new SplineCoefficients[result.size()]);
    }

    public static SplineCoefficients[] fitCoefficients(SplineObject object, double error) {
        SplineCoefficients[] result;
        try {
            result = SplineMath.tryFitCoefficients(object, error);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            result = SplineMath.fitWithOnlyStraightLines(object);
        }
        return result;
    }

    private static SplineCoefficients[] tryFitCoefficients(SplineObject object, double error) {
        ArrayList<SplineCoefficients> result = new ArrayList<SplineCoefficients>();
        double[] xs = object.getSplinePointIndepValues();
        double[] ys = object.getSplinePointDepValues();
        SplineObject.PointType[] pts = object.getSplinePointTypes();
        int n = xs.length;
        if (n < 2) {
            throw new RuntimeException("Must have more than 2 points");
        }
        int firstCuspIndex = -1;
        for (int i = 0; i < n; ++i) {
            if (pts[i] != SplineObject.PointType.CUSP && pts[i] != SplineObject.PointType.SQUARE) continue;
            firstCuspIndex = i;
            break;
        }
        if (firstCuspIndex == -1) {
            result.addAll(SplineMath.approxFit(xs, ys, EndPointType.SMOOTH, EndPointType.SMOOTH, error));
        } else {
            int iStart = firstCuspIndex;
            int iEnd = (firstCuspIndex + 1) % n;
            while (iEnd != firstCuspIndex) {
                EndPointType ptn;
                EndPointType pt0;
                int j = iStart;
                int sn = 1;
                for (int i = 0; i <= n; ++i) {
                    ++sn;
                    if (++j >= n) {
                        j -= n;
                    }
                    if (pts[j] != SplineObject.PointType.CUSP && pts[j] != SplineObject.PointType.SQUARE) continue;
                    iEnd = j;
                    break;
                }
                double[] sxs = new double[sn];
                double[] sys = new double[sn];
                j = iStart;
                for (int i = 0; i < sn; ++i) {
                    if (j >= n) {
                        j -= n;
                    }
                    sxs[i] = xs[j];
                    sys[i] = ys[j];
                    ++j;
                }
                switch (pts[iStart]) {
                    default: {
                        pt0 = EndPointType.CUSP;
                        break;
                    }
                    case SMOOTH: {
                        pt0 = EndPointType.SMOOTH;
                        break;
                    }
                    case SQUARE: {
                        double dx = Math.abs(xs[0] - xs[1]);
                        double dy = Math.abs(ys[0] - ys[1]);
                        pt0 = dy > dx ? EndPointType.VERT : EndPointType.HORIZ;
                    }
                }
                switch (pts[iEnd]) {
                    default: {
                        ptn = EndPointType.CUSP;
                        break;
                    }
                    case SMOOTH: {
                        ptn = EndPointType.SMOOTH;
                        break;
                    }
                    case SQUARE: {
                        int c = xs.length;
                        double dx = Math.abs(xs[c - 2] - xs[c - 1]);
                        double dy = Math.abs(ys[c - 2] - ys[c - 1]);
                        ptn = dy > dx ? EndPointType.VERT : EndPointType.HORIZ;
                    }
                }
                if (sn == 2) {
                    try {
                        result.addAll(SplineMath.approxFit(sxs, sys, pt0, ptn, error));
                    }
                    catch (RuntimeException e) {
                        result.addAll(SplineMath.approxFit(sxs, sys, EndPointType.CUSP, EndPointType.CUSP, error));
                    }
                } else {
                    result.addAll(SplineMath.approxFit(sxs, sys, pt0, ptn, error));
                }
                iStart = iEnd;
            }
        }
        return result.toArray(new SplineCoefficients[result.size()]);
    }

    private static List<SplineCoefficients> convertCoefficients(Matrix a) {
        int r = a.getRowDimension();
        int c = a.getColumnDimension();
        if (c != 1) {
            throw new RuntimeException("Number of columns should be 1, not " + c);
        }
        if (r % 8 != 0) {
            throw new RuntimeException("Number of rows should be a multiple of 8: " + r);
        }
        ArrayList<SplineCoefficients> result = new ArrayList<SplineCoefficients>();
        for (int i = 0; i < r; i += 8) {
            result.add(new SplineCoefficients(a.get(i + 0, 0), a.get(i + 1, 0), a.get(i + 2, 0), a.get(i + 3, 0), a.get(i + 4, 0), a.get(i + 5, 0), a.get(i + 6, 0), a.get(i + 7, 0)));
        }
        return result;
    }

    public static double getSplineParameterMax(SplineCoefficients[] scs) {
        double result = scs.length;
        return result;
    }

    public static double calcSplineXValue(SplineCoefficients[] scs, double s) {
        double p;
        int i = (int)Math.floor(s);
        if (i >= scs.length) {
            i = scs.length - 1;
        }
        if ((p = s - (double)i) > 1.0) {
            p = 1.0;
        }
        return scs[i].calcX(p);
    }

    public static double calcSplineYValue(SplineCoefficients[] scs, double s) {
        double p;
        int i = (int)Math.floor(s);
        if (i >= scs.length) {
            i = scs.length - 1;
        }
        if ((p = s - (double)i) > 1.0) {
            p = 1.0;
        }
        return scs[i].calcY(p);
    }

    public static enum EndPointType {
        CUSP,
        SMOOTH,
        VERT,
        HORIZ;

    }

    public static enum BoundaryCondition {
        EXTRAPOLATE_2ND_DERIVATIVE,
        SMOOTH_MIRROR,
        SMOOTH_CLOSED;

    }
}

