/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.splines;

import java.util.List;
import net.sourceforge.jocular.math.Polynomial;
import net.sourceforge.jocular.math.SturmSolver;

public class SplineCoefficients {
    public final Polynomial xSpline;
    public final Polynomial ySpline;

    public SplineCoefficients(double ax, double bx, double cx, double dx, double ay, double by, double cy, double dy) {
        this.xSpline = Polynomial.makeFromCoefficients(new double[]{dx, cx, bx, ax});
        this.ySpline = Polynomial.makeFromCoefficients(new double[]{dy, cy, by, ay});
    }

    public double calcX(double s) {
        if (s < -5.0E-14 || s > 1.00000000000005) {
            throw new RuntimeException("Value of s must be between 0 and 1, not " + s);
        }
        return this.xSpline.evaluate(s);
    }

    public double calcY(double s) {
        if (s < -5.0E-14 || s > 1.00000000000005) {
            throw new RuntimeException("Value of s must be between 0 and 1, not " + s);
        }
        return this.ySpline.evaluate(s);
    }

    public boolean isStraight() {
        return this.xSpline.order() < 2 && this.ySpline.order() < 2;
    }

    public double bestFitParameter(double x, double y) {
        double result = 0.0;
        Polynomial px = this.xSpline.subtract(Polynomial.makeFromCoefficients(new double[]{x}));
        Polynomial py = this.ySpline.subtract(Polynomial.makeFromCoefficients(new double[]{y}));
        Polynomial polyToMin = px.multiplyBy(px).add(py.multiplyBy(py)).derivative();
        List<Polynomial> sols = SturmSolver.factor(polyToMin, 0.0, 1.0);
        sols.add(Polynomial.makeFromRealRoots(new double[]{0.0}));
        sols.add(Polynomial.makeFromRealRoots(new double[]{1.0}));
        double bestErrSq = Double.MAX_VALUE;
        for (int i = 0; i < sols.size(); ++i) {
            Polynomial r = sols.get(i);
            if (r.order() != 1) continue;
            double s = r.linearRoot();
            double ex = px.evaluate(s);
            double ey = py.evaluate(s);
            double errSq = ey * ey + ex * ex;
            if (!(errSq < bestErrSq)) continue;
            result = s;
            bestErrSq = errSq;
        }
        return result;
    }

    public String toString() {
        return "SplineCoefficients x: " + this.xSpline + "; y: " + this.ySpline;
    }
}

