/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.splines;

import java.util.List;
import net.sourceforge.jocular.math.Polynomial;
import net.sourceforge.jocular.math.SturmSolver;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.splines.ExtrudedSplineInteractionCalculator;
import net.sourceforge.jocular.splines.RotatedSpline;
import net.sourceforge.jocular.splines.SplineCoefficients;
import net.sourceforge.jocular.splines.SplineCoefficientsOwner;
import net.sourceforge.jocular.splines.SplineObject;

public class RotatedSplineInteractionCalculator {
    public RotatedSplineInteractionCalculator(PhotonTrajectory pt, RotatedSpline s, InteractionSorter is) {
        RotatedSplineInteractionCalculator.computeInteractions(pt, s, is);
        double angle = s.getAngle();
        if (angle < Math.PI * 2) {
            Photon photon = pt.getPhoton();
            Vector3D pOrg = photon.getOrigin();
            Vector3D pDir = photon.getDirection();
            ObjectPositioner p = s.getPositioner();
            Vector3D oOrg = p.getOrigin();
            Vector3D oDir = p.getDirection();
            Vector3D oTrans = p.getTransDirection();
            Vector3D oOrtho = p.getOrthoDirection();
            Vector3D startOrg = oOrg;
            Vector3D startX = oDir;
            Vector3D startY = oOrtho;
            Vector3D startZ = oTrans.neg();
            Vector3D endOrg = oOrg;
            Vector3D endX = oDir;
            Vector3D endY = oOrtho.scale(Math.cos(angle)).add(oTrans.scale(Math.sin(angle)));
            Vector3D endZ = oOrtho.scale(Math.sin(angle)).add(oTrans.scale(Math.cos(angle)));
            SplineCoefficients[] scs = s.getSplineCoefficients();
            Vector3D startP = ExtrudedSplineInteractionCalculator.intersectsPolygon(scs, pOrg, pDir, startOrg, startX, startY, startZ);
            Vector3D endP = ExtrudedSplineInteractionCalculator.intersectsPolygon(scs, pOrg, pDir, endOrg, endX, endY, endZ);
            if (startP != null) {
                is.add(new PhotonInteraction(photon, s, (Object)ExtrudedSplineInteractionCalculator.ExtrusionEnd.FRONT, startP, startZ, "RotatedSpline front surface"));
            }
            if (endP != null) {
                is.add(new PhotonInteraction(photon, s, (Object)ExtrudedSplineInteractionCalculator.ExtrusionEnd.BACK, endP, endZ, "RotatedSpline back surface"));
            }
        }
    }

    private static SplineIntersectionResult computeRotationalIntersection(Vector3D ro, Vector3D rd, Vector3D po, Vector3D pd, SplineCoefficients sc) {
        Polynomial polyOfSToSolveOfS;
        double d = po.subtract(ro).dot(rd);
        double e = pd.dot(rd);
        Vector3D m = pd.subtract(rd.scale(e));
        Vector3D n = po.subtract(ro).subtract(rd.scale(d));
        double a = m.dot(m);
        double b = 2.0 * m.dot(n);
        double c = n.dot(n);
        Polynomial rSquaredOfP = Polynomial.makeFromCoefficients(new double[]{c, b, a});
        boolean eIsZero = Math.abs(e) < 5.0E-14;
        Polynomial zOfS = sc.xSpline;
        Polynomial rOfS = sc.ySpline;
        Polynomial pOfS = null;
        if (eIsZero) {
            polyOfSToSolveOfS = zOfS.subtract(Polynomial.makeFromCoefficients(new double[]{d}));
        } else {
            pOfS = zOfS.subtract(Polynomial.makeFromCoefficients(new double[]{d})).multiplyBy(1.0 / e);
            Polynomial rSquaredOfS = rSquaredOfP.absorb(pOfS);
            Polynomial rSquaredOfS2 = rOfS.power(2);
            polyOfSToSolveOfS = rSquaredOfS.subtract(rSquaredOfS2);
        }
        List<Polynomial> sRoots = SturmSolver.factor(polyOfSToSolveOfS, 0.0, 1.0);
        double m_bestP = Double.MAX_VALUE;
        double m_bestS = Double.NaN;
        for (Polynomial root : sRoots) {
            if (root.order() != 1) continue;
            double s = root.linearRoot();
            double e0 = s + 5.0E-14;
            double e1 = s - 1.0 - 5.0E-14;
            if (!(e0 > 0.0) || !(e1 < 0.0)) continue;
            double testP = Double.MAX_VALUE;
            if (eIsZero) {
                double rs2 = Math.pow(rOfS.evaluate(s), 2.0);
                Polynomial pt = rSquaredOfP.subtract(Polynomial.makeFromCoefficients(new double[]{rs2}));
                List<Polynomial> testPs = pt.factor();
                if (testPs.size() == 2) {
                    double tp1 = testPs.get(0).linearRoot();
                    double tp2 = testPs.get(1).linearRoot();
                    if (!(tp1 < 0.0) || !(tp2 < 0.0)) {
                        testP = tp1 < 0.0 ? tp2 : (tp2 < 0.0 ? tp1 : (tp2 > tp1 ? tp1 : tp2));
                    }
                }
            } else {
                testP = pOfS.evaluate(s);
            }
            if (!(m_bestP > testP) || !(testP > 5.0E-14)) continue;
            m_bestP = testP;
            m_bestS = s;
        }
        SplineIntersectionResult result = null;
        if (Double.isFinite(m_bestS)) {
            result = new SplineIntersectionResult(sc, m_bestS, m_bestP);
        }
        return result;
    }

    public static void computeInteractions(PhotonTrajectory pt, RotatedSpline object, InteractionSorter is) {
        SplineCoefficients[] scs;
        Photon p = pt.getPhoton();
        Vector3D po = p.getOrigin();
        Vector3D pd = p.getDirection();
        Vector3D ro = object.getPositioner().getOrigin();
        Vector3D rd = object.getPositioner().getDirection();
        Vector3D rtd = object.getPositioner().getTransDirection();
        Vector3D rod = object.getPositioner().getOrthoDirection();
        for (SplineCoefficients sc : scs = object.getSplineCoefficients()) {
            SplineIntersectionResult sir;
            if (!(sc.ySpline.maxCoeff() > 5.0E-14) || (sir = RotatedSplineInteractionCalculator.computeRotationalIntersection(ro, rd, po, pd, sc)) == null || !sir.isValid()) continue;
            Vector3D loc = pd.scale(sir.p).add(po);
            Vector3D dir = loc.subtract(ro);
            boolean doit = false;
            if (object.getAngle() >= Math.PI * 2) {
                doit = true;
            } else {
                double x;
                double y = rtd.dot(dir);
                double a = Math.atan2(y, x = rod.dot(dir));
                if (a < 0.0) {
                    a += Math.PI * 2;
                }
                if (a >= 0.0 && a <= object.getAngle()) {
                    doit = true;
                }
            }
            if (!doit) continue;
            RotatedSplineInteractionCalculator.addInteraction(sir, loc, po, pd, ro, rd, object, is, pt);
        }
    }

    protected static void addInteraction(SplineIntersectionResult sir, Vector3D loc, Vector3D po, Vector3D pd, Vector3D ro, Vector3D rd, SplineCoefficientsOwner object, InteractionSorter is, PhotonTrajectory pt) {
        double pMinDist = sir.p;
        double sMinDist = sir.s;
        Photon p = pt.getPhoton();
        SplineCoefficients bestSpline = sir.sc;
        double z = loc.subtract(ro).dot(rd);
        Vector3D vz = ro.add(rd.scale(z));
        Vector3D nOrtho = loc.subtract(vz).normalize();
        double dzds = -bestSpline.xSpline.derivative().evaluate(sMinDist);
        double drds = bestSpline.ySpline.derivative().evaluate(sMinDist);
        Vector3D norm = rd.scale(drds).add(nOrtho.scale(dzds));
        norm = norm.normalize();
        PhotonInteraction pi = new PhotonInteraction(p, object, sir.sc, loc, norm, "Rotated spline interaction");
        is.add(pi);
    }

    Vector3D getRotatedSplineNormal(SplineObject object) {
        return null;
    }

    protected static class SplineIntersectionResult {
        final SplineCoefficients sc;
        final double s;
        final double p;
        public static final SplineIntersectionResult NULL = new SplineIntersectionResult(null, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

        SplineIntersectionResult(SplineCoefficients sc, double s, double p) {
            this.sc = sc;
            this.s = s;
            this.p = p;
        }

        public boolean isValid() {
            return !Double.isNaN(this.p) && !Double.isNaN(this.s) && !Double.isInfinite(this.s) && !Double.isInfinite(this.p);
        }
    }
}

