/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.splines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsSurface;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.EnumArrayProperty;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.splines.RotatedSplineInteractionCalculator;
import net.sourceforge.jocular.splines.SplineCoefficients;
import net.sourceforge.jocular.splines.SplineMath;
import net.sourceforge.jocular.splines.SplineObject;

public class RotatedSpline
extends AbstractOpticsObject
implements SplineObject,
OpticsSurface {
    private SplineCoefficients[] m_coefficients = null;
    private EquationArrayProperty m_zPoints = new EquationArrayProperty("0.0", (PropertyOwner)this, PropertyKey.POINTS_X);
    private EquationArrayProperty m_radPoints = new EquationArrayProperty("0.0", (PropertyOwner)this, PropertyKey.POINTS_Y);
    private EnumArrayProperty m_pointTypes = new EnumArrayProperty(SplineObject.PointType.CUSP, "CUSP");
    private boolean m_splineDirty = true;
    private EquationProperty m_simplifyThreshold = new EquationProperty("0.0", this, PropertyKey.SIMPLIFY_THRESHOLD);
    private EquationProperty m_angle = new EquationProperty("360.0deg", this, PropertyKey.ANGLE);

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
        new RotatedSplineInteractionCalculator(pt, this, is);
    }

    @Override
    public void accept(OpticsObjectVisitor v) {
        v.visit(this);
    }

    @Override
    public int getSplinePointCount() {
        int nz = this.m_zPoints.size();
        int nr = this.m_radPoints.size();
        int nt = this.m_pointTypes.size();
        int nm = Math.min(nz, Math.min(nr, nt));
        return nm;
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case ANGLE: {
                this.m_angle = new EquationProperty(s, this, PropertyKey.ANGLE);
                this.firePropertyUpdated(key);
                break;
            }
            case POINTS_TYPES: {
                this.m_pointTypes = new EnumArrayProperty(SplineObject.PointType.CUSP, s);
                this.m_splineDirty = true;
                this.firePropertyUpdated(key);
                break;
            }
            case POINTS_X: {
                this.m_zPoints = new EquationArrayProperty(s, (PropertyOwner)this, key);
                this.m_splineDirty = true;
                this.firePropertyUpdated(key);
                break;
            }
            case POINTS_Y: {
                this.m_radPoints = new EquationArrayProperty(s, (PropertyOwner)this, key);
                this.m_splineDirty = true;
                this.firePropertyUpdated(key);
                break;
            }
            case SIMPLIFY_THRESHOLD: {
                this.m_simplifyThreshold = new EquationProperty(s, this, key);
                this.m_splineDirty = true;
                this.firePropertyUpdated(key);
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result = null;
        switch (key) {
            case ANGLE: {
                result = this.m_angle;
                break;
            }
            case POINTS_TYPES: {
                result = this.m_pointTypes;
                break;
            }
            case POINTS_X: {
                result = this.m_zPoints;
                break;
            }
            case POINTS_Y: {
                result = this.m_radPoints;
                break;
            }
            case SIMPLIFY_THRESHOLD: {
                result = this.m_simplifyThreshold;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.INSIDE_MATERIAL, PropertyKey.ANGLE, PropertyKey.SIMPLIFY_THRESHOLD, PropertyKey.POINTS_X, PropertyKey.POINTS_Y, PropertyKey.POINTS_TYPES));
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        RotatedSpline result = new RotatedSpline();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }

    @Override
    public double[] getSplinePointIndepValues() {
        UnitedValue[] zvs = this.m_zPoints.getValue();
        int n = this.getSplinePointCount();
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            double r = zvs[i].getBaseUnitValue();
            if (Double.isNaN(r)) {
                throw new RuntimeException("Value is NaN.");
            }
            result[i] = r;
        }
        return result;
    }

    @Override
    public double[] getSplinePointDepValues() {
        UnitedValue[] rvs = this.m_radPoints.getValue();
        int n = this.getSplinePointCount();
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            double r = rvs[i].getBaseUnitValue();
            if (Double.isNaN(r)) {
                throw new RuntimeException("Value is NaN.");
            }
            result[i] = r;
        }
        return result;
    }

    @Override
    public SplineObject.PointType[] getSplinePointTypes() {
        int n = this.m_pointTypes.size();
        SplineObject.PointType[] result = new SplineObject.PointType[n];
        for (int i = 0; i < n; ++i) {
            result[i] = (SplineObject.PointType)this.m_pointTypes.getValue()[i];
        }
        return result;
    }

    @Override
    public SplineCoefficients[] getSplineCoefficients() {
        if (this.m_splineDirty) {
            this.doInternalCalcs();
        }
        return this.m_coefficients;
    }

    @Override
    public void doInternalCalcs() {
        super.doInternalCalcs();
        this.m_angle.undefer(this, PropertyKey.ANGLE);
        ArrayList<SplineCoefficients> coeffs = new ArrayList<SplineCoefficients>();
        SplineCoefficients[] scs = SplineMath.fitCoefficients(this, this.m_simplifyThreshold.getValue().getBaseUnitValue());
        int z = -1;
        for (int i = 0; i < scs.length; ++i) {
            SplineCoefficients sc = scs[i];
            if (!(sc.ySpline.maxCoeff() < 5.0E-14)) continue;
            z = i;
        }
        int n = scs.length;
        for (int i = z + 1; i < z + n; ++i) {
            SplineCoefficients sc = scs[i % n];
            coeffs.add(sc);
        }
        this.m_coefficients = coeffs.toArray(new SplineCoefficients[coeffs.size()]);
        this.m_splineDirty = false;
    }

    public double getAngle() {
        return this.m_angle.getValue().getBaseUnitValue();
    }
}

