/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.splines;

import java.util.List;
import net.sourceforge.jocular.math.Polynomial;
import net.sourceforge.jocular.math.SturmSolver;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.splines.ExtrudedSpline;
import net.sourceforge.jocular.splines.SplineCoefficients;

public class ExtrudedSplineInteractionCalculator {
    public ExtrudedSplineInteractionCalculator(Photon photon, ExtrudedSpline extrudedSpline, InteractionSorter is) {
        this.testSplineSurface(photon, extrudedSpline, is);
        this.testSplineEnds(photon, extrudedSpline, is);
    }

    private void testSplineEnds(Photon photon, ExtrudedSpline extrudedSpline, InteractionSorter is) {
        Vector3D pDir = photon.getDirection();
        Vector3D pOrg = photon.getOrigin();
        Vector3D oTrans = extrudedSpline.getPositioner().getTransDirection();
        Vector3D oOrtho = extrudedSpline.getPositioner().getOrthoDirection();
        Vector3D oDir = extrudedSpline.getPositioner().getDirection();
        Vector3D oOrg = extrudedSpline.getPositioner().getOrigin();
        double thickness = ((EquationProperty)extrudedSpline.getProperty(PropertyKey.THICKNESS)).getValue().getBaseUnitValue();
        SplineCoefficients[] scs = extrudedSpline.getSplineCoefficients();
        Vector3D oFront = oOrg.add(oDir.scale(thickness / 2.0));
        Vector3D oBack = oOrg.add(oDir.scale(-thickness / 2.0));
        Vector3D pFront = ExtrudedSplineInteractionCalculator.intersectsPolygon(scs, pOrg, pDir, oFront, oOrtho, oTrans, oDir);
        Vector3D pBack = ExtrudedSplineInteractionCalculator.intersectsPolygon(scs, pOrg, pDir, oBack, oOrtho, oTrans, oDir);
        if (pFront != null) {
            is.add(new PhotonInteraction(photon, extrudedSpline, (Object)ExtrusionEnd.FRONT, pFront, oDir.neg(), "ExtrudedSpline front surface"));
        }
        if (pBack != null) {
            is.add(new PhotonInteraction(photon, extrudedSpline, (Object)ExtrusionEnd.BACK, pBack, oDir, "ExtrudedSpline back surface"));
        }
    }

    protected static Vector3D intersectsPolygon(SplineCoefficients[] scs, Vector3D pOrg, Vector3D pDir, Vector3D polyOrg, Vector3D polyDirX, Vector3D polyDirY, Vector3D polyDirZ) {
        double pPY;
        Vector3D pPlane;
        double pPX;
        Vector3D result = null;
        double dist = ExtrudedSplineInteractionCalculator.distanceAlongLineToPlane(pOrg, pDir, polyOrg, polyDirZ);
        if (Double.isFinite(dist) && dist >= 0.0 && ExtrudedSplineInteractionCalculator.isPointInside(scs, pPX = (pPlane = pOrg.add(pDir.scale(dist))).subtract(polyOrg).dot(polyDirX), pPY = pPlane.subtract(polyOrg).dot(polyDirY))) {
            result = pPlane;
        }
        return result;
    }

    private static boolean isPointInside(SplineCoefficients[] scs, double px, double py) {
        int passCount = 0;
        for (SplineCoefficients sc : scs) {
            Polynomial tp = sc.xSpline.subtract(Polynomial.makeFromCoefficients(new double[]{px}));
            SturmSolver ss = new SturmSolver(tp);
            ss.solve(0.0, 1.0);
            List<Polynomial> rs = ss.getRealRoots();
            for (Polynomial r : rs) {
                double s;
                double y;
                if (r.order() != 1 || !((y = sc.calcY(s = r.linearRoot())) - py > 5.0E-14)) continue;
                ++passCount;
            }
        }
        return passCount - 2 * (passCount / 2) > 0;
    }

    private static double distanceAlongLineToPlane(Vector3D lo, Vector3D ld, Vector3D po, Vector3D pn) {
        double cos = pn.dot(ld);
        double oDist = po.subtract(lo).dot(pn);
        double dDist = 0.0;
        dDist = cos != 0.0 ? oDist / cos : Double.NaN;
        return dDist;
    }

    public void testSplineSurface(Photon photon, ExtrudedSpline extrudedSpline, InteractionSorter is) {
        double ky;
        double kx;
        Vector3D pDir = photon.getDirection();
        Vector3D pOrg = photon.getOrigin();
        Vector3D oTrans = extrudedSpline.getPositioner().getTransDirection();
        Vector3D oOrtho = extrudedSpline.getPositioner().getOrthoDirection();
        Vector3D oDir = extrudedSpline.getPositioner().getDirection();
        Vector3D oOrg = extrudedSpline.getPositioner().getOrigin();
        double thickness = ((EquationProperty)extrudedSpline.getProperty(PropertyKey.THICKNESS)).getValue().getBaseUnitValue();
        SplineCoefficients[] scs = extrudedSpline.getSplineCoefficients();
        double pDY = pDir.dot(oTrans);
        double pDX = pDir.dot(oOrtho);
        Vector3D pOrgObj = pOrg.subtract(oOrg);
        double pOY = pOrgObj.dot(oTrans);
        double pOX = pOrgObj.dot(oOrtho);
        if (Math.abs(pDY) > Math.abs(pDX)) {
            if (pDX != 0.0) {
                kx = -pDY / pDX;
                ky = 1.0;
            } else {
                kx = 1.0;
                ky = 0.0;
            }
        } else if (pDY != 0.0) {
            kx = 1.0;
            ky = -pDX / pDY;
        } else {
            kx = 0.0;
            ky = 1.0;
        }
        for (SplineCoefficients sc : scs) {
            Polynomial polyToSolve = sc.xSpline.multiplyBy(kx).add(sc.ySpline.multiplyBy(ky));
            polyToSolve = polyToSolve.subtract(Polynomial.makeFromCoefficients(new double[]{pOX * kx + pOY * ky}));
            List<Polynomial> roots = SturmSolver.factor(polyToSolve, 0.0, 1.0);
            for (Polynomial root : roots) {
                Vector3D loc;
                double t;
                double p;
                if (root.order() != 1) continue;
                double s = root.linearRoot();
                if ((Math.abs(pOX) > Math.abs(pOY) || pDY == 0.0) && pDX != 0.0) {
                    double x = sc.calcX(s);
                    p = (x - pOX) / pDX;
                } else {
                    double y = sc.calcY(s);
                    p = (y - pOY) / pDY;
                }
                if (!(p > 0.0) || !((t = Math.abs((loc = pDir.scale(p).add(pOrg)).subtract(oOrg).dot(oDir))) * 2.0 < thickness)) continue;
                double dxds = sc.xSpline.derivative().evaluate(s);
                double dyds = -sc.ySpline.derivative().evaluate(s);
                Vector3D normal = oOrtho.scale(dyds).add(oTrans.scale(dxds)).normalize();
                is.add(new PhotonInteraction(photon, extrudedSpline, sc, loc, normal, "Extruded spline interaction"));
            }
        }
    }

    public static enum ExtrusionEnd {
        FRONT,
        BACK;

    }
}

