/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.splines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsSurface;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.EnumArrayProperty;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.splines.ExtrudedSplineInteractionCalculator;
import net.sourceforge.jocular.splines.SplineCoefficients;
import net.sourceforge.jocular.splines.SplineMath;
import net.sourceforge.jocular.splines.SplineObject;

public class ExtrudedSpline
extends AbstractOpticsObject
implements SplineObject,
OpticsSurface {
    private SplineCoefficients[] m_coefficients = null;
    private EquationProperty m_thickness = new EquationProperty("10mm", this, PropertyKey.THICKNESS);
    private EquationArrayProperty m_xPoints = new EquationArrayProperty("0.0", (PropertyOwner)this, PropertyKey.POINTS_X);
    private EquationArrayProperty m_yPoints = new EquationArrayProperty("0.0", (PropertyOwner)this, PropertyKey.POINTS_Y);
    private EnumArrayProperty m_pointTypes = new EnumArrayProperty(SplineObject.PointType.CUSP, "CUSP");
    private boolean m_splineDirty = true;
    private EquationProperty m_simplifyThreshold = new EquationProperty("0.0", this, PropertyKey.SIMPLIFY_THRESHOLD);

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
        new ExtrudedSplineInteractionCalculator(pt.getPhoton(), this, is);
    }

    @Override
    public void accept(OpticsObjectVisitor v) {
        v.visit(this);
    }

    @Override
    public int getSplinePointCount() {
        int nx = this.m_xPoints.size();
        int ny = this.m_yPoints.size();
        int nt = this.m_pointTypes.size();
        int nm = Math.min(nx, Math.min(ny, nt));
        return nm;
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case POINTS_TYPES: {
                this.m_pointTypes = new EnumArrayProperty(SplineObject.PointType.CUSP, s);
                this.m_splineDirty = true;
                break;
            }
            case POINTS_X: {
                this.m_xPoints = new EquationArrayProperty(s, (PropertyOwner)this, key);
                this.m_splineDirty = true;
                break;
            }
            case POINTS_Y: {
                this.m_yPoints = new EquationArrayProperty(s, (PropertyOwner)this, key);
                this.m_splineDirty = true;
                break;
            }
            case SIMPLIFY_THRESHOLD: {
                this.m_simplifyThreshold = new EquationProperty(s, this, key);
                this.m_splineDirty = true;
                break;
            }
            case THICKNESS: {
                this.m_thickness = new EquationProperty(s, this, key);
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
        if (this.getPropertyKeys().contains((Object)key)) {
            this.firePropertyUpdated(key);
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<Enum<?>[]> result = null;
        switch (key) {
            case POINTS_TYPES: {
                result = this.m_pointTypes;
                break;
            }
            case POINTS_X: {
                result = this.m_xPoints;
                break;
            }
            case POINTS_Y: {
                result = this.m_yPoints;
                break;
            }
            case SIMPLIFY_THRESHOLD: {
                result = this.m_simplifyThreshold;
                break;
            }
            case THICKNESS: {
                result = this.m_thickness;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.INSIDE_MATERIAL, PropertyKey.SIMPLIFY_THRESHOLD, PropertyKey.POINTS_X, PropertyKey.THICKNESS, PropertyKey.POINTS_Y, PropertyKey.POINTS_TYPES));
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        ExtrudedSpline result = new ExtrudedSpline();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }

    @Override
    public double[] getSplinePointIndepValues() {
        UnitedValue[] xvs = this.m_xPoints.getValue();
        int n = this.getSplinePointCount();
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = xvs[i].getBaseUnitValue();
        }
        return result;
    }

    @Override
    public double[] getSplinePointDepValues() {
        UnitedValue[] yvs = this.m_yPoints.getValue();
        int n = this.getSplinePointCount();
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = yvs[i].getBaseUnitValue();
        }
        return result;
    }

    @Override
    public SplineObject.PointType[] getSplinePointTypes() {
        int n = this.m_pointTypes.size();
        SplineObject.PointType[] result = new SplineObject.PointType[n];
        for (int i = 0; i < n; ++i) {
            result[i] = (SplineObject.PointType)this.m_pointTypes.getValue()[i];
        }
        return result;
    }

    @Override
    public SplineCoefficients[] getSplineCoefficients() {
        if (this.m_splineDirty) {
            this.doInternalCalcs();
        }
        return this.m_coefficients;
    }

    @Override
    public void doInternalCalcs() {
        super.doInternalCalcs();
        if (!this.m_xPoints.isDeferred() && !this.m_yPoints.isDeferred()) {
            SplineCoefficients[] scs = SplineMath.fitCoefficients(this, this.m_simplifyThreshold.getValue().getBaseUnitValue());
            this.m_coefficients = scs;
            this.m_splineDirty = false;
        }
    }
}

