/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.sources;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.sourceforge.jocular.imager.OpticsColour;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.photons.Polarization;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.BooleanProperty;
import net.sourceforge.jocular.properties.EnumProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.ImageProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.sources.HemiPointSource;
import net.sourceforge.jocular.sources.LightSource;
import net.sourceforge.jocular.sources.SourceCalcs;

public class ImageSource
extends AbstractOpticsObject
implements LightSource {
    private EquationProperty m_meanWavelength = new EquationProperty("600nm", this, PropertyKey.WAVELENGTH_MEAN);
    private EquationProperty m_fwhmWavelength = new EquationProperty("10nm", this, PropertyKey.WAVELENGTH_FWHM);
    double m_sdWavelength = 1.0E-8;
    private EquationProperty m_transHalfAngleLimit = new EquationProperty("30deg", this, PropertyKey.TRANS_ANGLE);
    private EquationProperty m_orthoHalfAngleLimit = new EquationProperty("0deg", this, PropertyKey.ORTHO_ANGLE);
    private EquationProperty m_phaseFwhm = new EquationProperty("10deg", this, PropertyKey.PHASE_FWHM);
    private EquationProperty m_xSize = new EquationProperty("10cm", this, PropertyKey.ORTHO_SIZE);
    private EquationProperty m_ySize = new EquationProperty("10cm", this, PropertyKey.TRANS_SIZE);
    private ImageProperty m_image = new ImageProperty();
    private BooleanProperty m_greyScale = new BooleanProperty("true");
    private EquationProperty m_apertureDistance = new EquationProperty("10cm", this, PropertyKey.APERTURE_DISTANCE);
    private EquationProperty m_apertureDiameter = new EquationProperty("1cm", this, PropertyKey.APERTURE_DIAMETER);
    private EnumProperty m_pixelType = new EnumProperty(PixelType.MONO, PixelType.MONO.name());
    private EnumProperty m_emissionPattern = new EnumProperty(ImageSourceEmissionPattern.ANGLE, ImageSourceEmissionPattern.ANGLE.name());
    private static final Random random = new Random(0L);

    @Override
    public void accept(OpticsObjectVisitor v) {
        v.visit(this);
    }

    @Override
    public PhotonTrajectory getNewPhotonTrajectory(OpticsObject outerObject) {
        Vector3D dir = this.m_positioner.getDirection();
        Vector3D trans = this.m_positioner.getTransDirection();
        Vector3D ortho = this.m_positioner.getOrthoDirection();
        BufferedImage image = this.m_image.getValue();
        Vector3D origin = null;
        double w = 6.0E-7;
        double i = 0.0;
        while (i == 0.0) {
            double orthoPos = random.nextDouble();
            double transPos = random.nextDouble();
            int xI = (int)Math.floor(orthoPos * (double)image.getWidth());
            int yI = (int)Math.floor(transPos * (double)image.getHeight());
            Color c = new Color(image.getRGB(xI, yI), true);
            double a = c.getAlpha();
            double b = (double)c.getRed() * 0.3 / 255.0 + (double)c.getGreen() * 0.59 / 255.0 + (double)c.getBlue() * 0.11 / 255.0;
            b *= a;
            if (this.m_pixelType.getValue() == PixelType.COLOUR) {
                switch (random.nextInt(3)) {
                    case 0: {
                        i = (double)c.getRed() / 255.0 * a;
                        w = 6.25E-7;
                        break;
                    }
                    case 1: {
                        i = (double)c.getGreen() / 255.0 * a;
                        w = 5.25E-7;
                        break;
                    }
                    case 2: {
                        i = (double)c.getBlue() / 255.0 * a;
                        w = 4.5E-7;
                    }
                }
            } else {
                w = this.m_meanWavelength.getValue().getBaseUnitValue();
                double wSd = this.m_fwhmWavelength.getValue().getBaseUnitValue() * HemiPointSource.STDEV_OVER_FWHM;
                if (wSd != 0.0) {
                    w += random.nextGaussian() * wSd;
                }
                i = b;
            }
            orthoPos = (orthoPos - 0.5) * this.m_xSize.getValue().getBaseUnitValue();
            transPos = (transPos - 0.5) * this.m_ySize.getValue().getBaseUnitValue();
            origin = this.m_positioner.getOrigin().add(trans.scale(transPos)).add(ortho.scale(orthoPos));
        }
        if (this.m_emissionPattern.getValue() == ImageSourceEmissionPattern.ANGLE) {
            dir = SourceCalcs.calcPhotonDir(this.m_positioner, this.m_orthoHalfAngleLimit.getValue().getBaseUnitValue(), this.m_transHalfAngleLimit.getValue().getBaseUnitValue());
        } else {
            double apRad = this.m_apertureDiameter.getValue().getBaseUnitValue() / 2.0;
            double pointRad = apRad * random.nextDouble();
            double pointAngle = random.nextDouble() * 2.0 * Math.PI;
            Vector3D apPoint = this.m_positioner.getOrigin().add(dir.scale(this.m_apertureDistance.getValue().getBaseUnitValue()));
            double tScale = pointRad * Math.sin(pointAngle);
            double oScale = pointRad * Math.cos(pointAngle);
            dir = apPoint.add(trans.scale(tScale)).add(ortho.scale(oScale)).subtract(origin).normalize();
        }
        Vector3D bTrans = dir.cross(this.m_positioner.getTransDirection()).normalize();
        Vector3D bOrtho = Vector3D.getOrtho(dir, bTrans);
        double rAngle = 0.0;
        double magA = 1.0;
        double magB = 0.0;
        double phaseA = 0.0;
        double phaseB = 0.0;
        Vector3D dirA = bTrans.scale(Math.sin(rAngle)).add(bOrtho.scale(Math.cos(rAngle)));
        Vector3D dirB = dir.cross(dirA);
        Photon p = new Photon(origin, dir, w, new Polarization(dirA, dirB, magA, magB, phaseA, phaseB), Photon.PhotonSource.EMITTED, i, outerObject);
        PhotonInteraction newPi = new PhotonInteraction(p, origin, this, dir, "Emitted.");
        return new PhotonTrajectory(p, newPi);
    }

    @Override
    public double getIntesity() {
        return 0.0;
    }

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
    }

    @Override
    public void interact(PhotonInteraction pi, PhotonTrajectory pt) {
    }

    protected void updateDimensions() {
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case TRANS_SIZE: {
                this.m_ySize = new EquationProperty(s, this, key);
                this.updateDimensions();
                break;
            }
            case ORTHO_SIZE: {
                this.m_xSize = new EquationProperty(s, this, key);
                this.updateDimensions();
                break;
            }
            case WAVELENGTH_MEAN: {
                this.m_meanWavelength = new EquationProperty(s, this, key);
                break;
            }
            case PHASE_FWHM: {
                this.m_phaseFwhm = new EquationProperty(s, this, key);
                break;
            }
            case WAVELENGTH_FWHM: {
                this.m_fwhmWavelength = new EquationProperty(s, this, key);
                this.m_sdWavelength = this.m_fwhmWavelength.getValue().getBaseUnitValue() * HemiPointSource.STDEV_OVER_FWHM;
                break;
            }
            case WAVELENGTH_STDEV: {
                EquationProperty lp = new EquationProperty(s, this, key);
                this.m_fwhmWavelength = new EquationProperty(lp.getValue().getBaseUnitValue() / HemiPointSource.STDEV_OVER_FWHM);
                this.m_sdWavelength = this.m_fwhmWavelength.getValue().getBaseUnitValue() * HemiPointSource.STDEV_OVER_FWHM;
                break;
            }
            case TRANS_ANGLE: {
                this.m_transHalfAngleLimit = new EquationProperty(s, this, key);
                break;
            }
            case ORTHO_ANGLE: {
                this.m_orthoHalfAngleLimit = new EquationProperty(s, this, key);
                break;
            }
            case IMAGE: {
                this.m_image = new ImageProperty(s);
                break;
            }
            case GREY_SCALE: {
                this.m_greyScale = new BooleanProperty(s);
                break;
            }
            case EMISSION_PATTERN: {
                this.m_emissionPattern = new EnumProperty(ImageSourceEmissionPattern.ANGLE, s);
                break;
            }
            case APERTURE_DIAMETER: {
                this.m_apertureDiameter = new EquationProperty(s, this, key);
                break;
            }
            case APERTURE_DISTANCE: {
                this.m_apertureDistance = new EquationProperty(s, this, key);
                break;
            }
            case PIXEL_TYPE: {
                this.m_pixelType = new EnumProperty(PixelType.MONO, s);
                this.updateDimensions();
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
        if (this.getPropertyKeys().contains((Object)key)) {
            this.firePropertyUpdated(key);
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result;
        switch (key) {
            case TRANS_SIZE: {
                result = this.m_ySize;
                break;
            }
            case ORTHO_SIZE: {
                result = this.m_xSize;
                break;
            }
            case WAVELENGTH_MEAN: {
                result = this.m_meanWavelength;
                break;
            }
            case PHASE_FWHM: {
                result = this.m_phaseFwhm;
                break;
            }
            case WAVELENGTH_FWHM: {
                result = this.m_fwhmWavelength;
                break;
            }
            case WAVELENGTH_STDEV: {
                result = new EquationProperty(this.m_fwhmWavelength.getValue().getBaseUnitValue() * HemiPointSource.STDEV_OVER_FWHM);
                break;
            }
            case TRANS_ANGLE: {
                result = this.m_transHalfAngleLimit;
                break;
            }
            case ORTHO_ANGLE: {
                result = this.m_orthoHalfAngleLimit;
                break;
            }
            case IMAGE: {
                result = this.m_image;
                break;
            }
            case GREY_SCALE: {
                result = this.m_greyScale;
                break;
            }
            case EMISSION_PATTERN: {
                result = this.m_emissionPattern;
                break;
            }
            case APERTURE_DIAMETER: {
                result = this.m_apertureDiameter;
                break;
            }
            case APERTURE_DISTANCE: {
                result = this.m_apertureDistance;
                break;
            }
            case PIXEL_TYPE: {
                result = this.m_pixelType;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.TRANS_SIZE, PropertyKey.ORTHO_SIZE, PropertyKey.IMAGE, PropertyKey.GREY_SCALE, PropertyKey.WAVELENGTH_MEAN, PropertyKey.WAVELENGTH_FWHM, PropertyKey.PHASE_FWHM, PropertyKey.PIXEL_TYPE, PropertyKey.EMISSION_PATTERN, PropertyKey.APERTURE_DIAMETER, PropertyKey.APERTURE_DISTANCE, PropertyKey.TRANS_ANGLE, PropertyKey.ORTHO_ANGLE));
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        ImageSource result = new ImageSource();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }

    public BufferedImage getImage() {
        BufferedImage bi = this.m_image.getValue();
        if (this.m_greyScale.getValue().booleanValue()) {
            BufferedImage bi2 = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
            int w = bi.getWidth();
            int h = bi.getHeight();
            OpticsColour c = OpticsColour.getColorFromWavelength(this.m_meanWavelength.getValue().getBaseUnitValue(), this.m_fwhmWavelength.getValue().getBaseUnitValue());
            ColorModel cm = bi.getColorModel();
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    int r = bi.getRGB(x, y) & 0xFF;
                    double dr = (double)r / 255.0;
                    int rgb = c.makeBright(dr).getIntRgb();
                    bi2.setRGB(x, y, rgb);
                }
            }
            bi = bi2;
        }
        return bi;
    }

    public static enum PixelType {
        COLOUR("Colour"),
        MONO("Monochrome");

        private final String m_name;

        private PixelType(String n2) {
            this.m_name = n2;
        }

        public String toString() {
            return this.m_name;
        }
    }

    public static enum ImageSourceEmissionPattern {
        ANGLE("Angle"),
        APERTURE("Aperture");

        private final String m_name;

        private ImageSourceEmissionPattern(String n2) {
            this.m_name = n2;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

