/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.sources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.photons.Polarization;
import net.sourceforge.jocular.positioners.OffsetPositioner;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.sources.LightSource;
import net.sourceforge.jocular.sources.SourceCalcs;

public class HemiPointSource
extends AbstractOpticsObject
implements LightSource {
    public static final double STDEV_OVER_FWHM = 1.0 / (2.0 * Math.sqrt(2.0 * Math.log(2.0)));
    private EquationProperty m_meanWavelength = new EquationProperty("600nm", this, PropertyKey.WAVELENGTH_MEAN);
    private EquationProperty m_fwhmWavelength = new EquationProperty("10nm", this, PropertyKey.WAVELENGTH_FWHM);
    double m_sdWavelength = 1.0E-8;
    private EquationProperty m_transHalfAngleLimit = new EquationProperty("30deg", this, PropertyKey.TRANS_ANGLE);
    private EquationProperty m_orthoHalfAngleLimit = new EquationProperty("30deg", this, PropertyKey.ORTHO_ANGLE);
    private EquationProperty m_phaseFwhm = new EquationProperty("10deg", this, PropertyKey.PHASE_FWHM);
    private static final Random random = new Random(0L);
    double maxAngle = 0.0;

    public HemiPointSource() {
        this.setPositioner(new OffsetPositioner());
    }

    @Override
    public PhotonTrajectory getNewPhotonTrajectory(OpticsObject outerObject) {
        Vector3D dir = SourceCalcs.calcPhotonDir(this.m_positioner, this.m_orthoHalfAngleLimit.getValue().getBaseUnitValue(), this.m_transHalfAngleLimit.getValue().getBaseUnitValue());
        double w = this.m_meanWavelength.getValue().getBaseUnitValue();
        double wSd = this.m_fwhmWavelength.getValue().getBaseUnitValue() * STDEV_OVER_FWHM;
        if (wSd != 0.0) {
            w += random.nextGaussian() * wSd;
        }
        Photon p = new Photon(this.m_positioner.getOrigin(), dir, w, this.getNextPolarization(dir), Photon.PhotonSource.EMITTED, 1.0, outerObject);
        PhotonInteraction newPi = new PhotonInteraction(p, this.m_positioner.getOrigin(), this, dir, "Emitted.");
        return new PhotonTrajectory(p, newPi);
    }

    private Polarization getNextPolarization(Vector3D dir) {
        Vector3D bTrans = dir.cross(this.m_positioner.getTransDirection()).normalize();
        Vector3D bOrtho = Vector3D.getOrtho(dir, bTrans);
        double rAngle = random.nextDouble() * 2.0 * Math.PI;
        Vector3D dirA = bTrans.scale(Math.sin(rAngle)).add(bOrtho.scale(Math.cos(rAngle)));
        Vector3D dirB = Vector3D.getOrtho(dir, dirA);
        double magA = random.nextDouble();
        double magB = Math.sqrt(1.0 - Math.pow(magA, 2.0));
        double phaseA = 0.0;
        double phaseB = 0.0;
        double phaseSd = this.m_phaseFwhm.getValue().getBaseUnitValue() * STDEV_OVER_FWHM;
        if (phaseSd != 0.0) {
            phaseA = random.nextGaussian() * phaseSd;
            phaseB = random.nextGaussian() * phaseSd;
            magA = random.nextDouble();
            magB = Math.sqrt(1.0 - Math.pow(magA, 2.0));
        }
        return new Polarization(dirA, dirB, magA, magB, phaseA, phaseB);
    }

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
    }

    @Override
    public void interact(PhotonInteraction pi, PhotonTrajectory pt) {
    }

    @Override
    public double getIntesity() {
        return 1.0;
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case WAVELENGTH_MEAN: {
                this.m_meanWavelength = new EquationProperty(s, this, key);
                break;
            }
            case PHASE_FWHM: {
                this.m_phaseFwhm = new EquationProperty(s, this, key);
                break;
            }
            case WAVELENGTH_FWHM: {
                this.m_fwhmWavelength = new EquationProperty(s, this, key);
                this.m_sdWavelength = this.m_fwhmWavelength.getValue().getBaseUnitValue() * STDEV_OVER_FWHM;
                break;
            }
            case WAVELENGTH_STDEV: {
                EquationProperty lp = new EquationProperty(s, this, key);
                this.m_fwhmWavelength = new EquationProperty(lp.getValue().getBaseUnitValue() / STDEV_OVER_FWHM);
                this.m_sdWavelength = this.m_fwhmWavelength.getValue().getBaseUnitValue() * STDEV_OVER_FWHM;
                break;
            }
            case TRANS_ANGLE: {
                this.m_transHalfAngleLimit = new EquationProperty(s, this, key);
                break;
            }
            case ORTHO_ANGLE: {
                this.m_orthoHalfAngleLimit = new EquationProperty(s, this, key);
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result;
        switch (key) {
            case WAVELENGTH_MEAN: {
                result = this.m_meanWavelength;
                break;
            }
            case PHASE_FWHM: {
                result = this.m_phaseFwhm;
                break;
            }
            case WAVELENGTH_FWHM: {
                result = this.m_fwhmWavelength;
                break;
            }
            case WAVELENGTH_STDEV: {
                result = new EquationProperty(this.m_fwhmWavelength.getValue().getBaseUnitValue() * STDEV_OVER_FWHM);
                break;
            }
            case TRANS_ANGLE: {
                result = this.m_transHalfAngleLimit;
                break;
            }
            case ORTHO_ANGLE: {
                result = this.m_orthoHalfAngleLimit;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.WAVELENGTH_MEAN, PropertyKey.WAVELENGTH_FWHM, PropertyKey.PHASE_FWHM, PropertyKey.TRANS_ANGLE, PropertyKey.ORTHO_ANGLE));
        return result;
    }

    @Override
    public void accept(OpticsObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public OpticsObject makeCopy() {
        HemiPointSource result = new HemiPointSource();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }
}

