/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.settings;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import net.sourceforge.jocular.gui.tables.OpticsPropertyTable;
import net.sourceforge.jocular.gui.tables.OpticsPropertyTableModel;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.settings.Settings;

public class SettingsDialog
extends JDialog {
    private final OpticsPropertyTableModel m_model = new OpticsPropertyTableModel();
    private OpticsPropertyTable m_table = new OpticsPropertyTable(this.m_model);

    public SettingsDialog(Frame owner, Settings s, OpticsProject p) {
        super(owner);
        this.m_model.setPropertyOwner(s, p);
        this.initializeDisplay();
        this.initializePanels();
    }

    private void initializeDisplay() {
        this.setSize(new Dimension(300, 300));
    }

    private void initializePanels() {
        Box b = new Box(1);
        b.add(new JScrollPane(this.m_table));
        JPanel panel = new JPanel();
        panel.add(this.createOKButton());
        panel.add(this.createResetButton());
        b.add(panel);
        this.add(b);
    }

    private JButton createOKButton() {
        JButton okButton = new JButton("Done");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableCellEditor tce = SettingsDialog.this.m_table.getCellEditor();
                if (tce != null) {
                    tce.stopCellEditing();
                }
                SettingsDialog.this.dispose();
            }
        });
        return okButton;
    }

    private JButton createResetButton() {
        JButton okButton = new JButton("Reset");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettingsDialog.this.resetValuesToDefault();
            }
        });
        return okButton;
    }

    private void resetValuesToDefault() {
        int result = JOptionPane.showConfirmDialog(null, "This will reset all settings to their default values.\nA restart is required for changes to take effect.", "Confirm Reset", 2);
        if (result == 0) {
            Settings.SETTINGS.restoreDefaults();
        }
    }
}

