/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import net.sourceforge.jocular.Jocular;
import net.sourceforge.jocular.gui.panel.OutputPanel;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.properties.BooleanProperty;
import net.sourceforge.jocular.properties.EnumProperty;
import net.sourceforge.jocular.properties.FileArrayProperty;
import net.sourceforge.jocular.properties.IntegerProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.properties.StringProperty;
import net.sourceforge.jocular.settings.SettingKey;

public class Settings
implements PropertyOwner {
    static final NumberDisplay DEFAULT_NUMBER_DISPLAY = NumberDisplay.EQUATION;
    static final int DEFAULT_TRAJECTORY_COUNT = 1;
    static final OutputPanel.PhotonRenderColour DEFAULT_PHOTON_COLOUR = OutputPanel.PhotonRenderColour.MATERIAL;
    static final String DEFAULT_MOST_PROBABLE = "false";
    static final String DEFAULT_USE_POLARIZATION = "false";
    static final String DEFAULT_FILE_PATH = "";
    public static final int DEFAULT_WIN_X_LOC = 0;
    public static final int DEFAULT_WIN_Y_LOC = 0;
    public static final int DEFAULT_WINDOW_HEIGHT = 600;
    public static final int DEFAULT_WINDOW_WIDTH = 600;
    public static final int DEFAULT_SPLIT_LOC = 0;
    public static final double MIN_DISTANCE = 1.0E-11;
    public static final double HC_CONSTANT = 1.98644568E-25;
    public static final int DEFAULT_NUM_WRANGLER_THREADS = 1;
    public static final Settings SETTINGS = new Settings();
    private final Preferences m_prefs = Preferences.userNodeForPackage(Jocular.class);
    private IntegerProperty m_trajectoryCount = new IntegerProperty(String.valueOf(1));
    private IntegerProperty m_trajectoryDisplayCount = new IntegerProperty(String.valueOf(1));
    private EnumProperty m_photonColour = new EnumProperty(DEFAULT_PHOTON_COLOUR, DEFAULT_PHOTON_COLOUR.name());
    private BooleanProperty m_pickMostProbable = new BooleanProperty("false");
    private BooleanProperty m_usePolarizationInImager = new BooleanProperty("false");
    private EnumProperty m_numberDisplay = new EnumProperty(DEFAULT_NUMBER_DISPLAY, DEFAULT_NUMBER_DISPLAY.name());
    private StringProperty m_defaultFilePath = new StringProperty("");
    private IntegerProperty m_imgWinXLoc = new IntegerProperty(String.valueOf(0));
    private IntegerProperty m_imgWinYLoc = new IntegerProperty(String.valueOf(0));
    private IntegerProperty m_imgWinHeight = new IntegerProperty(String.valueOf(600));
    private IntegerProperty m_imgWinWidth = new IntegerProperty(String.valueOf(600));
    private IntegerProperty m_mainWinXLoc = new IntegerProperty(String.valueOf(0));
    private IntegerProperty m_mainWinYLoc = new IntegerProperty(String.valueOf(0));
    private IntegerProperty m_mainWinHeight = new IntegerProperty(String.valueOf(600));
    private IntegerProperty m_mainWinWidth = new IntegerProperty(String.valueOf(600));
    private IntegerProperty m_mainWinSplitHorizontal = new IntegerProperty(String.valueOf(0));
    private IntegerProperty m_mainWinSplitTree = new IntegerProperty(String.valueOf(0));
    private IntegerProperty m_mainWinSplitPositioner = new IntegerProperty(String.valueOf(0));
    public IntegerProperty m_mainWinSplitGeometry = new IntegerProperty(String.valueOf(0));
    public IntegerProperty m_numWranglerThreads = new IntegerProperty(String.valueOf(1));
    public FileArrayProperty m_recentFiles = new FileArrayProperty("");
    private Collection<PropertyUpdatedListener> m_propertyUpdatedListeners = new ArrayList<PropertyUpdatedListener>();

    public void initialize() {
        for (PropertyKey key : this.getPropertyKeys()) {
            String s = this.m_prefs.get(key.name(), DEFAULT_FILE_PATH);
            if (s == DEFAULT_FILE_PATH) continue;
            this.setProperty(key, s);
        }
        for (SettingKey key : this.getSettingKeys()) {
            String s = this.m_prefs.get(key.name(), DEFAULT_FILE_PATH);
            if (s == DEFAULT_FILE_PATH) continue;
            this.setSetting(key, s);
        }
    }

    @Override
    public void addPropertyUpdatedListener(PropertyUpdatedListener listener) {
        if (!this.m_propertyUpdatedListeners.contains(listener)) {
            this.m_propertyUpdatedListeners.add(listener);
        }
    }

    @Override
    public void removePropertyUpdatedListener(PropertyUpdatedListener listener) {
        this.m_propertyUpdatedListeners.remove(listener);
    }

    @Override
    public void firePropertyUpdated(PropertyKey key) {
        for (PropertyUpdatedListener listener : this.m_propertyUpdatedListeners) {
            listener.propertyUpdated(new PropertyUpdatedEvent(this, key));
        }
    }

    public void store() {
        for (PropertyKey key : this.getPropertyKeys()) {
            this.m_prefs.put(key.name(), this.getProperty(key).getDefiningString());
        }
        for (SettingKey key : this.getSettingKeys()) {
            this.m_prefs.put(key.name(), this.getSetting(key).getDefiningString());
        }
    }

    public void restoreDefaults() {
        for (SettingKey key : this.getSettingKeys()) {
            this.setSetting(key, this.getSettingDefault(key));
        }
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case TRAJECTORY_COUNT: {
                this.m_trajectoryCount = new IntegerProperty(s);
                break;
            }
            case TRAJECTORY_DISPLAY_COUNT: {
                this.m_trajectoryDisplayCount = new IntegerProperty(s);
                break;
            }
            case PHOTON_COLOUR_SCHEME: {
                this.m_photonColour = new EnumProperty(OutputPanel.PhotonRenderColour.MATERIAL, s);
                break;
            }
            case PICK_MOST_PROBABLE: {
                this.m_pickMostProbable = new BooleanProperty(s);
                break;
            }
            case USE_POLARIZATION: {
                this.m_usePolarizationInImager = new BooleanProperty(s);
                break;
            }
            case WRANGLER_THREAD_COUNT: {
                this.m_numWranglerThreads = new IntegerProperty(s);
                break;
            }
            case EQUATION_DISPLAY: {
                this.m_numberDisplay = new EnumProperty(NumberDisplay.EQUATION, s);
                break;
            }
            case RECENT_FILES: {
                this.m_recentFiles = new FileArrayProperty(s);
                break;
            }
        }
        this.m_prefs.put(key.name(), s);
        this.firePropertyUpdated(key);
    }

    public void setSetting(SettingKey key, String s) {
        switch (key) {
            case IMG_WIN_HEIGHT: {
                this.m_imgWinHeight = new IntegerProperty(s);
                break;
            }
            case IMG_WIN_WIDTH: {
                this.m_imgWinWidth = new IntegerProperty(s);
                break;
            }
            case IMG_WIN_X_LOC: {
                this.m_imgWinXLoc = new IntegerProperty(s);
                break;
            }
            case IMG_WIN_Y_LOC: {
                this.m_imgWinYLoc = new IntegerProperty(s);
                break;
            }
            case MAIN_WIN_HEIGHT: {
                this.m_mainWinHeight = new IntegerProperty(s);
                break;
            }
            case MAIN_WIN_WIDTH: {
                this.m_mainWinWidth = new IntegerProperty(s);
                break;
            }
            case MAIN_WIN_X_LOC: {
                this.m_mainWinXLoc = new IntegerProperty(s);
                break;
            }
            case MAIN_WIN_Y_LOC: {
                this.m_mainWinYLoc = new IntegerProperty(s);
                break;
            }
            case MAIN_WIN_SPLIT_HORIZ: {
                this.m_mainWinSplitHorizontal = new IntegerProperty(s);
                break;
            }
            case MAIN_WIN_SPLIT_TREE: {
                this.m_mainWinSplitTree = new IntegerProperty(s);
                break;
            }
            case MAIN_WIN_SPLIT_POS: {
                this.m_mainWinSplitPositioner = new IntegerProperty(s);
                break;
            }
            case MAIN_WIN_SPLIT_GEO: {
                this.m_mainWinSplitGeometry = new IntegerProperty(s);
                break;
            }
            case DEFAULT_FILE_PATH: {
                this.m_defaultFilePath = new StringProperty(s);
                break;
            }
        }
        this.m_prefs.put(key.name(), s);
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<Integer> result;
        switch (key) {
            case TRAJECTORY_COUNT: {
                result = this.m_trajectoryCount;
                break;
            }
            case TRAJECTORY_DISPLAY_COUNT: {
                result = this.m_trajectoryDisplayCount;
                break;
            }
            case PHOTON_COLOUR_SCHEME: {
                result = this.m_photonColour;
                break;
            }
            case PICK_MOST_PROBABLE: {
                result = this.m_pickMostProbable;
                break;
            }
            case USE_POLARIZATION: {
                result = this.m_usePolarizationInImager;
                break;
            }
            case WRANGLER_THREAD_COUNT: {
                result = this.m_numWranglerThreads;
                break;
            }
            case EQUATION_DISPLAY: {
                result = this.m_numberDisplay;
                break;
            }
            case RECENT_FILES: {
                result = this.m_recentFiles;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public Property<?> getSetting(SettingKey key) {
        Property<Integer> result;
        switch (key) {
            case IMG_WIN_HEIGHT: {
                result = this.m_imgWinHeight;
                break;
            }
            case IMG_WIN_WIDTH: {
                result = this.m_imgWinWidth;
                break;
            }
            case IMG_WIN_X_LOC: {
                result = this.m_imgWinXLoc;
                break;
            }
            case IMG_WIN_Y_LOC: {
                result = this.m_imgWinYLoc;
                break;
            }
            case MAIN_WIN_HEIGHT: {
                result = this.m_mainWinHeight;
                break;
            }
            case MAIN_WIN_WIDTH: {
                result = this.m_mainWinWidth;
                break;
            }
            case MAIN_WIN_X_LOC: {
                result = this.m_mainWinXLoc;
                break;
            }
            case MAIN_WIN_Y_LOC: {
                result = this.m_mainWinYLoc;
                break;
            }
            case MAIN_WIN_SPLIT_HORIZ: {
                result = this.m_mainWinSplitHorizontal;
                break;
            }
            case MAIN_WIN_SPLIT_TREE: {
                result = this.m_mainWinSplitTree;
                break;
            }
            case MAIN_WIN_SPLIT_POS: {
                result = this.m_mainWinSplitPositioner;
                break;
            }
            case MAIN_WIN_SPLIT_GEO: {
                result = this.m_mainWinSplitGeometry;
                break;
            }
            case DEFAULT_FILE_PATH: {
                result = this.m_defaultFilePath;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private String getSettingDefault(SettingKey key) {
        String result;
        switch (key) {
            case IMG_WIN_HEIGHT: {
                result = String.valueOf(600);
                break;
            }
            case IMG_WIN_WIDTH: {
                result = String.valueOf(600);
                break;
            }
            case IMG_WIN_X_LOC: {
                result = String.valueOf(0);
                break;
            }
            case IMG_WIN_Y_LOC: {
                result = String.valueOf(0);
                break;
            }
            case MAIN_WIN_HEIGHT: {
                result = String.valueOf(600);
                break;
            }
            case MAIN_WIN_WIDTH: {
                result = String.valueOf(600);
                break;
            }
            case MAIN_WIN_X_LOC: {
                result = String.valueOf(0);
                break;
            }
            case MAIN_WIN_Y_LOC: {
                result = String.valueOf(0);
                break;
            }
            case MAIN_WIN_SPLIT_HORIZ: 
            case MAIN_WIN_SPLIT_TREE: 
            case MAIN_WIN_SPLIT_POS: 
            case MAIN_WIN_SPLIT_GEO: {
                result = String.valueOf(0);
                break;
            }
            case DEFAULT_FILE_PATH: {
                result = DEFAULT_FILE_PATH;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.TRAJECTORY_COUNT, PropertyKey.TRAJECTORY_DISPLAY_COUNT, PropertyKey.PHOTON_COLOUR_SCHEME, PropertyKey.PICK_MOST_PROBABLE, PropertyKey.USE_POLARIZATION, PropertyKey.WRANGLER_THREAD_COUNT, PropertyKey.EQUATION_DISPLAY, PropertyKey.RECENT_FILES));
        return result;
    }

    @Override
    public List<Property<?>> getProperties() {
        ArrayList result = new ArrayList();
        for (PropertyKey key : this.getPropertyKeys()) {
            result.add(this.getProperty(key));
        }
        return result;
    }

    private SettingKey[] getSettingKeys() {
        SettingKey[] result = new SettingKey[]{SettingKey.DEFAULT_FILE_PATH, SettingKey.IMG_WIN_HEIGHT, SettingKey.IMG_WIN_WIDTH, SettingKey.IMG_WIN_X_LOC, SettingKey.IMG_WIN_Y_LOC, SettingKey.MAIN_WIN_HEIGHT, SettingKey.MAIN_WIN_WIDTH, SettingKey.MAIN_WIN_X_LOC, SettingKey.MAIN_WIN_Y_LOC, SettingKey.MAIN_WIN_SPLIT_HORIZ, SettingKey.MAIN_WIN_SPLIT_TREE, SettingKey.MAIN_WIN_SPLIT_POS, SettingKey.MAIN_WIN_SPLIT_GEO};
        return result;
    }

    @Override
    public void copyProperties(PropertyOwner o) {
        for (PropertyKey k : this.getPropertyKeys()) {
            this.copyProperty(o, k);
        }
    }

    @Override
    public void copyProperty(PropertyOwner owner, PropertyKey k) {
    }

    public Integer getPhotonTrajectoryCount() {
        return this.m_trajectoryCount.getValue();
    }

    public int getPhotonTrajectoryDisplayCount() {
        return this.m_trajectoryDisplayCount.getValue();
    }

    public OutputPanel.PhotonRenderColour getPhotonColourScheme() {
        return (OutputPanel.PhotonRenderColour)((Object)this.m_photonColour.getValue());
    }

    public boolean isPickMostProbable() {
        return this.m_pickMostProbable.getValue();
    }

    public boolean usePolarizationInImager() {
        return this.m_usePolarizationInImager.getValue();
    }

    public int getNumberWranglerThreads() {
        return this.m_numWranglerThreads.getValue();
    }

    public String getDefaultFilePath() {
        return this.m_defaultFilePath.getValue();
    }

    public int getImgWinXLoc() {
        return this.m_imgWinXLoc.getValue();
    }

    public int getImgWinYLoc() {
        return this.m_imgWinYLoc.getValue();
    }

    public int getImgWinHeight() {
        return this.m_imgWinHeight.getValue();
    }

    public int getImgWinWidth() {
        return this.m_imgWinWidth.getValue();
    }

    public int getMainWinXLoc() {
        return this.m_mainWinXLoc.getValue();
    }

    public int getMainWinYLoc() {
        return this.m_mainWinYLoc.getValue();
    }

    public int getMainWinHeight() {
        return this.m_mainWinHeight.getValue();
    }

    public int getMainWinWidth() {
        return this.m_mainWinWidth.getValue();
    }

    public int getMainWinSplitHorizontal() {
        return this.m_mainWinSplitHorizontal.getValue();
    }

    public int getMainWinSplitTree() {
        return this.m_mainWinSplitTree.getValue();
    }

    public int getMainWinSplitPositioner() {
        return this.m_mainWinSplitPositioner.getValue();
    }

    public int getMainWinSplitGeometry() {
        return this.m_mainWinSplitGeometry.getValue();
    }

    public NumberDisplay getNumberDisplay() {
        return (NumberDisplay)((Object)this.m_numberDisplay.getValue());
    }

    @Override
    public boolean isSame(OpticsObject o) {
        return false;
    }

    @Override
    public void doInternalCalcs() {
    }

    public File[] getRecentFiles() {
        return this.m_recentFiles.getValue();
    }

    public void addRecentFile(File f) {
        boolean alreadyExists = false;
        FileArrayProperty fap = this.m_recentFiles;
        for (File tf : fap.getValue()) {
            if (!tf.equals(f)) continue;
            alreadyExists = true;
            break;
        }
        if (alreadyExists) {
            return;
        }
        fap = new FileArrayProperty(this.m_recentFiles.addRowToDefiningString(0));
        if (fap.size() > 5) {
            fap = new FileArrayProperty(fap.removeRowFromDefiningString(5));
        }
        File[] fs = fap.getValue();
        fs[0] = f;
        if (fs != null) {
            fap = new FileArrayProperty(fs);
            this.setProperty(PropertyKey.RECENT_FILES, fap.getDefiningString());
        }
    }

    public static enum NumberDisplay {
        EQUATION,
        METRIC,
        IMPERIAL;

    }
}

