/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;

public class PropertyOwnerInterestList {
    private List<PropertyOwnerLink> m_linkList = new CopyOnWriteArrayList<PropertyOwnerLink>();

    public List<PropertyOwnerLink> getLinksToOwnersInterestedIn(PropertyOwner o, PropertyKey k) {
        ArrayList<PropertyOwnerLink> result = new ArrayList<PropertyOwnerLink>();
        for (PropertyOwnerLink ool : this.m_linkList) {
            if (ool.getInterestingPropertyKey() == PropertyKey.FRONT_RADIUS) {
                // empty if block
            }
            if (ool.getInterestingOwner() != o || ool.getInterestingPropertyKey() != k) continue;
            result.add(ool);
        }
        return result;
    }

    public List<PropertyOwner> getOwnersInterestingTo(PropertyOwner o) {
        ArrayList<PropertyOwner> result = new ArrayList<PropertyOwner>();
        for (PropertyOwnerLink ool : this.m_linkList) {
            if (ool.getInterestedOwner() != o) continue;
            result.add(ool.getInterestingOwner());
            break;
        }
        return result;
    }

    public void addOwnerInterest(PropertyOwner interestedOwner, PropertyKey interestedKey, PropertyOwner interestingOwner, PropertyKey interestingKey) {
        this.m_linkList.add(new PropertyOwnerLink(interestedOwner, interestedKey, interestingOwner, interestingKey));
    }

    public PropertyOwnerLink findFirstLinkOfInterest(PropertyOwner interestedOwner) {
        PropertyOwnerLink result = null;
        for (PropertyOwnerLink ool : this.m_linkList) {
            if (ool.getInterestedOwner() != interestedOwner) continue;
            result = ool;
            break;
        }
        return result;
    }

    public List<PropertyOwnerLink> getInterestingLinks(PropertyOwner interestingOwner, PropertyKey interestingKey) {
        ArrayList<PropertyOwnerLink> result = new ArrayList<PropertyOwnerLink>();
        for (PropertyOwnerLink link : this.m_linkList) {
            if (link.getInterestingOwner() != interestingOwner || link.getInterestingPropertyKey() != interestingKey) continue;
            result.add(link);
        }
        return result;
    }

    public List<PropertyOwnerLink> getLinksOfInterest(PropertyOwner interestedOwner, PropertyKey interestedKey) {
        ArrayList<PropertyOwnerLink> result = new ArrayList<PropertyOwnerLink>();
        for (PropertyOwnerLink link : this.m_linkList) {
            if (link.getInterestedOwner() != interestedOwner || link.getInterestedPropertyKey() != interestedKey) continue;
            result.add(link);
        }
        return result;
    }

    public void removeOwnerInterest(PropertyOwner interestedOwner, PropertyKey interestedKey) {
        List<PropertyOwnerLink> links = this.getLinksOfInterest(interestedOwner, interestedKey);
        for (PropertyOwnerLink link : links) {
            this.m_linkList.remove(link);
        }
    }

    public boolean doesLinkExist(PropertyOwner interestedOwner, PropertyKey interestedKey, PropertyOwner interestingOwner, PropertyKey interestingKey) {
        boolean result = false;
        PropertyOwnerLink testLink = new PropertyOwnerLink(interestedOwner, interestedKey, interestingOwner, interestingKey);
        for (PropertyOwnerLink l : this.m_linkList) {
            if (!l.equals(testLink)) continue;
            result = true;
            break;
        }
        return result;
    }

    public PropertyOwnerLink checkForCircularReference(PropertyOwner interestedOwner, PropertyKey interestedKey, PropertyOwner interestingOwner, PropertyKey interestingKey) {
        PropertyOwnerLink result = null;
        if (interestingOwner == interestedOwner && interestingKey == interestedKey) {
            result = new PropertyOwnerLink(interestedOwner, interestedKey, interestingOwner, interestingKey);
        } else {
            List<PropertyOwnerLink> pols = this.getLinksOfInterest(interestingOwner, interestingKey);
            for (PropertyOwnerLink pol : pols) {
                if (pol.getInterestingOwner() == interestedOwner && pol.getInterestingPropertyKey() == interestedKey) {
                    result = pol;
                    break;
                }
                result = this.checkForCircularReference(interestedOwner, interestedKey, pol.getInterestingOwner(), pol.getInterestingPropertyKey());
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    public String toString() {
        Object result = "PropertyOwnerInterestList: \n";
        for (PropertyOwnerLink link : this.m_linkList) {
            result = (String)result + "     " + link + "\n";
        }
        return result;
    }

    public void updateAllInterests() {
        for (PropertyOwnerLink link : this.m_linkList) {
            link.getInterestingOwner().doInternalCalcs();
        }
    }

    public class PropertyOwnerLink {
        PropertyOwner m_interestedOwner;
        PropertyOwner m_interestingOwner;
        PropertyKey m_interestedKey;
        PropertyKey m_interestingKey;

        public PropertyOwnerLink(PropertyOwner interestedOwner, PropertyKey interestedKey, PropertyOwner interestingOwner, PropertyKey interestingKey) {
            this.m_interestedOwner = interestedOwner;
            this.m_interestedKey = interestedKey;
            this.m_interestingOwner = interestingOwner;
            this.m_interestingKey = interestingKey;
        }

        public PropertyOwner getInterestedOwner() {
            return this.m_interestedOwner;
        }

        public PropertyOwner getInterestingOwner() {
            return this.m_interestingOwner;
        }

        public PropertyKey getInterestedPropertyKey() {
            return this.m_interestedKey;
        }

        public PropertyKey getInterestingPropertyKey() {
            return this.m_interestingKey;
        }

        public String toString() {
            Property<?> p1 = this.m_interestedOwner.getProperty(PropertyKey.NAME);
            String sp1 = "null";
            if (p1 != null) {
                sp1 = p1.getDefiningString();
            }
            Property<?> p2 = this.m_interestingOwner.getProperty(PropertyKey.NAME);
            String sp2 = "null";
            if (p2 != null) {
                sp2 = p2.getDefiningString();
            }
            return "PropertyOwnerLink: \"" + sp1 + "\" (" + this.m_interestedOwner + ") > " + this.m_interestedKey + " is interested in \"" + sp2 + "\" (" + this.m_interestingOwner + ") > " + this.m_interestingKey;
        }

        public boolean equals(PropertyOwnerLink link) {
            boolean result = true;
            if (link.getInterestedOwner() != this.getInterestedOwner()) {
                result = false;
            }
            if (link.getInterestedPropertyKey() != this.getInterestedPropertyKey()) {
                result = false;
            }
            if (link.getInterestingOwner() != this.getInterestingOwner()) {
                result = false;
            }
            if (link.getInterestingPropertyKey() != this.getInterestingPropertyKey()) {
                result = false;
            }
            return result;
        }
    }
}

