/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.properties;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.math.equations.PropertyNotFoundException;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectCombo;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.OpticsPart;
import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.CalculatedProperty;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyOwnerInterestList;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;

public class PropertyManager
implements PropertyUpdatedListener {
    private static final PropertyManager PM_SINGLETON = new PropertyManager();
    private CopyOnWriteArrayList<OpticsProject> m_projects = new CopyOnWriteArrayList();
    private static EquationParser m_equationParser = new EquationParser();
    private PropertyOwnerInterestList m_interestList = new PropertyOwnerInterestList();
    private String m_updateReference = null;
    private CopyOnWriteArrayList<OpticsProject> m_notDeferredProjects = new CopyOnWriteArrayList();

    private PropertyManager() {
    }

    public static PropertyManager getInstance() {
        return PM_SINGLETON;
    }

    public List<UnitedValue> parseEquation(String s, PropertyOwner po, PropertyKey key) {
        boolean namedThisTime;
        if (this.isDeferred(this.getProject(po))) {
            return Collections.singletonList(UnitedValue.DEFERRED);
        }
        this.removeInterest(po, key);
        if (this.m_updateReference == null) {
            namedThisTime = true;
            Property<?> p = po.getProperty(PropertyKey.NAME);
            this.m_updateReference = DateFormat.getDateTimeInstance().format(new Date());
            this.m_updateReference = this.m_updateReference + " " + po.getClass().getSimpleName() + " ";
            this.m_updateReference = p != null ? this.m_updateReference + "\"" + p.getDefiningString() + "\"" : this.m_updateReference + "null";
            this.m_updateReference = this.m_updateReference + ">" + key;
        } else {
            namedThisTime = false;
        }
        List<UnitedValue> result = m_equationParser.parse(s, po, this, key);
        if (namedThisTime) {
            this.m_updateReference = null;
        }
        return result;
    }

    public UnitedValue lookupObjectProperty(String objectName, String propertyName, PropertyOwner po, PropertyKey key) {
        UnitedValue result = null;
        List<OpticsObject> os = this.getObjectByName(objectName, po);
        if (os.size() > 1) {
            return UnitedValue.makeError(EquationParser.CalcState.UNDERSPECIFIED_OBJECT);
        }
        if (os.size() == 0) {
            return UnitedValue.makeError(EquationParser.CalcState.OBJECT_NOT_FOUND);
        }
        OpticsObject o = os.get(0);
        PropertyKey pk = this.getPropertyKey(o, propertyName);
        Property<?> p = o.getProperty(pk);
        if (!this.addInterest(po, key, o, pk)) {
            result = UnitedValue.makeError(EquationParser.CalcState.CIRCULAR_REFERENCE);
        } else if (p instanceof EquationProperty) {
            EquationProperty ep = (EquationProperty)p;
            ep.undefer(o, pk);
            result = UnitedValue.makeFunctionResult(ep.getValue().getUnit(), ep.getValue().getValue());
        } else {
            result = UnitedValue.makeError(EquationParser.CalcState.PROPERTY_NOT_NUMBER);
        }
        return result;
    }

    private boolean addInterest(PropertyOwner interestedOwner, PropertyKey interestedKey, PropertyOwner interestingOwner, PropertyKey interestingKey) {
        PropertyOwnerInterestList.PropertyOwnerLink pol;
        boolean result = false;
        if (!this.m_interestList.doesLinkExist(interestedOwner, interestedKey, interestingOwner, interestingKey) && (pol = this.m_interestList.checkForCircularReference(interestedOwner, interestedKey, interestingOwner, interestingKey)) == null) {
            this.m_interestList.addOwnerInterest(interestedOwner, interestedKey, interestingOwner, interestingKey);
            interestingOwner.addPropertyUpdatedListener(this);
            result = true;
        }
        return result;
    }

    public UnitedValue lookupObjectPositionerProperty(String objectName, String propertyName, PropertyOwner po, PropertyKey key) {
        UnitedValue result;
        List<OpticsObject> os = this.getObjectByName(objectName, po);
        if (os.size() > 1) {
            return UnitedValue.makeError(EquationParser.CalcState.UNDERSPECIFIED_OBJECT);
        }
        if (os.size() == 0) {
            return UnitedValue.makeError(EquationParser.CalcState.OBJECT_NOT_FOUND);
        }
        OpticsObject o = os.get(0);
        ObjectPositioner pos = o.getPositioner();
        PropertyKey pk = this.getPropertyKey(pos, propertyName);
        Property<?> p = pos.getProperty(pk);
        if (!this.addInterest(po, key, pos, pk)) {
            return UnitedValue.makeError(EquationParser.CalcState.CIRCULAR_REFERENCE);
        }
        if (p instanceof EquationProperty) {
            EquationProperty ep = (EquationProperty)p;
            if (ep.isDeferred()) {
                ep.undefer(pos, pk);
            }
            UnitedValue uv = ep.getValue();
            result = UnitedValue.makeFunctionResult(uv.getUnit(), uv.getValue());
        } else {
            result = UnitedValue.makeError(EquationParser.CalcState.PROPERTY_NOT_NUMBER);
        }
        return result;
    }

    protected void removeInterest(PropertyOwner interestedOwner, PropertyKey interestedKey) {
        this.m_interestList.removeOwnerInterest(interestedOwner, interestedKey);
    }

    public void addProject(OpticsProject p) {
        if (!this.m_projects.contains(p)) {
            this.m_projects.add(p);
            ProjectRootGroup o = p.getOpticsObject();
            o.doInternalCalcs();
        }
    }

    public void removeProject(OpticsProject p) {
        Collection<OpticsObject> parts = p.getOpticsObject().getFlattenedObjectsOfType(OpticsPart.class, true);
        this.m_projects.remove(p);
        this.m_projects.removeAll(parts);
    }

    public List<OpticsObject> getObjectByName(String n, PropertyOwner po) {
        OpticsProject p = this.getProject(po);
        if (p == null) {
            return new ArrayList<OpticsObject>();
        }
        return this.getObjectByName(p.getOpticsObject(), n);
    }

    protected boolean isNamedObject(OpticsObject o, String n) {
        boolean result = false;
        String s = o.getProperty(PropertyKey.NAME).getDefiningString();
        if (s.toLowerCase().trim().equals(n.toLowerCase().trim())) {
            result = true;
        } else if (o.getID().isMatch(n)) {
            result = true;
        }
        return result;
    }

    public PropertyKey getPropertyKey(PropertyOwner o, String n) {
        PropertyKey key = null;
        for (PropertyKey pk : o.getPropertyKeys()) {
            if (!pk.getDescription().toLowerCase().startsWith(n.toLowerCase())) continue;
            key = pk;
            break;
        }
        if (key == null) {
            System.out.println("PropertyManager.getProperty can't find property with name \"" + n + "\" in " + o.getClass().getSimpleName());
            throw new PropertyNotFoundException(n);
        }
        return key;
    }

    public List<OpticsObject> getObjectByName(OpticsObject o, String n) {
        ArrayList<OpticsObject> result = new ArrayList<OpticsObject>();
        if (this.isNamedObject(o, n)) {
            result.add(o);
        }
        if (o instanceof OpticsObjectGroup) {
            OpticsObjectGroup g = (OpticsObjectGroup)o;
            for (OpticsObject ot : g.getObjects()) {
                result.addAll(this.getObjectByName(ot, n));
            }
        }
        return result;
    }

    public OpticsProject getProject(PropertyOwner po) {
        OpticsProject result = null;
        int bestProjLevel = Integer.MAX_VALUE;
        for (OpticsProject p : this.m_projects) {
            int i = this.isInObject(po, p.getOpticsObject(), 0);
            if (i < 0 || i >= bestProjLevel) continue;
            result = p;
            bestProjLevel = i;
        }
        return result;
    }

    protected int isInObject(PropertyOwner theObject, OpticsObject theObjectToLookIn, int level) {
        int result;
        block2: {
            OpticsObject ot;
            block1: {
                result = -1;
                if (!theObject.isSame(theObjectToLookIn)) break block1;
                result = level;
                break block2;
            }
            if (!(theObjectToLookIn instanceof OpticsObjectCombo)) break block2;
            OpticsObjectCombo ooc = (OpticsObjectCombo)((Object)theObjectToLookIn);
            Iterator<OpticsObject> iterator = ooc.getObjects().iterator();
            while (iterator.hasNext() && (result = this.isInObject(theObject, ot = iterator.next(), level + 1)) < 0) {
            }
        }
        return result;
    }

    @Override
    public void propertyUpdated(PropertyUpdatedEvent e) {
        List<PropertyOwnerInterestList.PropertyOwnerLink> ls = this.m_interestList.getLinksToOwnersInterestedIn(e.getPropertyOwnerSource(), e.getPropertyKey());
        for (PropertyOwnerInterestList.PropertyOwnerLink pol : ls) {
            Property<?> p = pol.getInterestedOwner().getProperty(pol.getInterestedPropertyKey());
            if (!(p instanceof CalculatedProperty)) continue;
            CalculatedProperty cp = (CalculatedProperty)((Object)p);
            cp.calcValue(pol.getInterestedOwner(), pol.getInterestedPropertyKey());
        }
    }

    public void updateAllInterests() {
        this.m_interestList.updateAllInterests();
    }

    public static String getRelativePath(PropertyOwner owner, File file) {
        URI rp;
        if (file == null) {
            return "";
        }
        OpticsProject p = PropertyManager.getInstance().getProject(owner);
        URI fp = file.toURI();
        if (p != null && !p.getFileName().equals("")) {
            URI pp = p.getFile().getParentFile().toURI();
            rp = pp.relativize(fp);
        } else {
            rp = fp;
        }
        return rp.toString();
    }

    public static File loadRelative(File relativeTo, String filename) {
        File file = null;
        if (relativeTo != null) {
            URI uri = null;
            try {
                uri = new URI(PropertyManager.removeSpaces(filename));
                uri = relativeTo.toURI().resolve(uri);
                file = new File(uri);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static String removeSpaces(String s) {
        String result = s.replace(" ", "%20");
        return result;
    }

    public void deferParsing(OpticsProject p) {
        this.m_notDeferredProjects.remove(p);
    }

    public void undeferParsing(OpticsProject p) {
        if (p != null) {
            this.m_notDeferredProjects.addIfAbsent(p);
            p.getOpticsObject().doInternalCalcs();
        }
    }

    private void undefer(OpticsObject oo) {
        if (oo instanceof OpticsObjectGroup) {
            for (OpticsObject oot : ((OpticsObjectGroup)oo).getObjects()) {
                this.undefer(oot);
            }
        } else {
            for (PropertyKey pk : oo.getPropertyKeys()) {
                EquationArrayProperty eap;
                Property<?> p = oo.getProperty(pk);
                if (p instanceof EquationProperty) {
                    EquationProperty ep = (EquationProperty)p;
                    if (!ep.isDeferred()) continue;
                    ep.calcValue(oo, pk);
                    continue;
                }
                if (!(p instanceof EquationArrayProperty) || !(eap = (EquationArrayProperty)p).isDeferred()) continue;
                eap.calcValue(oo, pk);
            }
        }
    }

    private boolean isDeferred(OpticsProject p) {
        return !this.m_notDeferredProjects.contains(p);
    }

    public UnitedValue lookupGlobalVariable(PropertyOwner owner, PropertyKey interestedKey, String name) {
        UnitedValue result = UnitedValue.makeError(EquationParser.CalcState.VARIABLE_NOT_FOUND);
        OpticsProject p = this.getProject(owner);
        ProjectRootGroup oo = p.getOpticsObject();
        Property<?> prop = oo.getProperty(PropertyKey.VARIABLES);
        if (prop instanceof EquationArrayProperty) {
            EquationArrayProperty eap = (EquationArrayProperty)prop;
            for (int i = 0; i < eap.getEquationCount(); ++i) {
                EquationProperty ep = eap.getEquation(i);
                String n = ep.getVariableName();
                if (n == null || !n.toLowerCase().contains(name.toLowerCase())) continue;
                result = ep.getValue();
                this.addInterest(owner, interestedKey, oo, PropertyKey.VARIABLES);
                break;
            }
        }
        return result;
    }

    public EquationProperty[] splitEquations(EquationArrayProperty eap, PropertyOwner owner, PropertyKey key, boolean onlyLhs) {
        return m_equationParser.split(eap, owner, key, this, onlyLhs);
    }
}

