/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.properties;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.mesh.MeshData;
import net.sourceforge.jocular.mesh.MeshTriangle;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyVisitor;

public class MeshDataProperty
implements Property<MeshData> {
    private MeshData m_data = new MeshData();
    ArrayList<MeshTriangle> ts = new ArrayList();

    public MeshDataProperty(String s) {
        ByteBuffer bb = ByteBuffer.wrap(Base64.getDecoder().decode(s.getBytes(Charset.forName("UTF-8"))));
        FloatBuffer db = bb.asFloatBuffer();
        while (db.remaining() >= 9) {
            float x1 = db.get();
            float y1 = db.get();
            float z1 = db.get();
            float x2 = db.get();
            float y2 = db.get();
            float z2 = db.get();
            float x3 = db.get();
            float y3 = db.get();
            float z3 = db.get();
            Vector3D v1 = new Vector3D(x1, y1, z1);
            Vector3D v2 = new Vector3D(x2, y2, z2);
            Vector3D v3 = new Vector3D(x3, y3, z3);
            this.m_data.addTriangle(v1, v2, v3);
        }
    }

    public MeshDataProperty(MeshData data) {
        this.m_data = data;
    }

    @Override
    public String getDefiningString() {
        ByteBuffer bb = ByteBuffer.allocate(this.m_data.getTriangleCount() * 4 * 9);
        FloatBuffer db = bb.asFloatBuffer();
        for (int i = 0; i < this.m_data.getTriangleCount(); ++i) {
            db.put((float)this.m_data.getTriangleVertex((int)i, (int)0).x);
            db.put((float)this.m_data.getTriangleVertex((int)i, (int)0).y);
            db.put((float)this.m_data.getTriangleVertex((int)i, (int)0).z);
            db.put((float)this.m_data.getTriangleVertex((int)i, (int)1).x);
            db.put((float)this.m_data.getTriangleVertex((int)i, (int)1).y);
            db.put((float)this.m_data.getTriangleVertex((int)i, (int)1).z);
            db.put((float)this.m_data.getTriangleVertex((int)i, (int)2).x);
            db.put((float)this.m_data.getTriangleVertex((int)i, (int)2).y);
            db.put((float)this.m_data.getTriangleVertex((int)i, (int)2).z);
        }
        String result = Base64.getEncoder().encodeToString(bb.array());
        return result;
    }

    @Override
    public void accept(PropertyVisitor v) {
        v.visit(this);
    }

    @Override
    public MeshData getValue() {
        return this.m_data;
    }
}

