/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.properties;

import net.sourceforge.jocular.materials.Acrylite2447;
import net.sourceforge.jocular.materials.EskaPof;
import net.sourceforge.jocular.materials.Liba2000;
import net.sourceforge.jocular.materials.Nsf57;
import net.sourceforge.jocular.materials.Nsk14;
import net.sourceforge.jocular.materials.OpticalMaterial;
import net.sourceforge.jocular.materials.SLah79;
import net.sourceforge.jocular.materials.SchottB270;
import net.sourceforge.jocular.materials.SimpleOpticalMaterial;
import net.sourceforge.jocular.materials.TotalAbsorber;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyVisitor;

public class MaterialProperty
implements Property<OpticalMaterial> {
    protected final MaterialKey m_key;
    protected final OpticalMaterial m_material;

    public MaterialProperty(String s) {
        MaterialKey key = null;
        for (MaterialKey k : MaterialKey.values()) {
            if (!k.name().equals(s)) continue;
            key = k;
            break;
        }
        this.m_key = key;
        if (this.m_key == null) {
            throw new RuntimeException("MaterialProperty: String \"" + s + "\" does not match a MaterialKey.");
        }
        this.m_material = this.m_key.getMaterial();
    }

    public String toString() {
        return this.m_key.toString();
    }

    @Override
    public String getDefiningString() {
        if (this.m_key != null) {
            return this.m_key.name();
        }
        return null;
    }

    @Override
    public void accept(PropertyVisitor v) {
        v.visit(this);
    }

    public MaterialKey getKey() {
        return this.m_key;
    }

    @Override
    public OpticalMaterial getValue() {
        return this.m_material;
    }

    public static enum MaterialKey {
        VACUUM("Vacuum", SimpleOpticalMaterial.VACUUM),
        BOROSILICATE("Borosilicate", SimpleOpticalMaterial.BOROSILICATE),
        ESKA_POF("Eska POF", new EskaPof()),
        N_BK7("N-BK7", SimpleOpticalMaterial.N_BK7),
        SCHOTT_B270("B270", new SchottB270()),
        SF10("SF10", SimpleOpticalMaterial.SF10),
        SF18("SF18", SimpleOpticalMaterial.SF18),
        F2("F2", SimpleOpticalMaterial.F2),
        N_SF2("N-SF2", SimpleOpticalMaterial.N_SF2),
        N_SF5("N-SF5", SimpleOpticalMaterial.N_SF5),
        N_SF57("N-SF57", new Nsf57()),
        N_SK2("N-SK2", SimpleOpticalMaterial.N_SK2),
        N_SK14("N-SK14", new Nsk14()),
        S_LAH79("S-LAH79", new SLah79()),
        LBAL32("L-BAL35", SimpleOpticalMaterial.LBAL35),
        LIBA2000("Liba 2000", new Liba2000()),
        MAGNESIUM_FLUORIDE("Magnesium Fluoride", SimpleOpticalMaterial.MAGNESIUM_FLUORIDE),
        CALCITE("Calcite", SimpleOpticalMaterial.CALCITE),
        POLYCARBONATE("Polycarbonate", SimpleOpticalMaterial.POLYCARBONATE),
        TOPAS5013LS("Topas 5013LS-10", SimpleOpticalMaterial.TOPAS5013LS),
        ACRYLITE2447("Acrylite 2447", new Acrylite2447()),
        SHINYMETAL("Total Reflector", SimpleOpticalMaterial.SHINYMETAL),
        TOTAL_ABSORBER("Total Absorber", new TotalAbsorber());

        private final String m_description;
        private final OpticalMaterial m_material;

        private MaterialKey(String description, OpticalMaterial m) {
            this.m_description = description;
            this.m_material = m;
        }

        public String toString() {
            return this.m_description;
        }

        public OpticalMaterial getMaterial() {
            return this.m_material;
        }

        public static MaterialKey getKey(OpticalMaterial m) {
            MaterialKey result = null;
            for (MaterialKey k : MaterialKey.values()) {
                if (k.getMaterial().getClass() != m.getClass()) continue;
                result = k;
                break;
            }
            return result;
        }
    }
}

