/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.properties;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyVisitor;

public class ImageProperty
implements Property<BufferedImage> {
    private final BufferedImage m_image;

    public ImageProperty() {
        this.m_image = new BufferedImage(10, 10, 12);
    }

    public ImageProperty(BufferedImage i) {
        this.m_image = i;
    }

    public ImageProperty(String s) {
        byte[] bytes = new byte[]{};
        try {
            bytes = Base64.getDecoder().decode(s);
        }
        catch (Exception e) {
            throw new RuntimeException("ImageProperty constructor failed to create image. " + s.length());
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        BufferedImage i = null;
        try {
            i = ImageIO.read(is);
        }
        catch (IOException e) {
            System.out.println("ImageProperty constructor failed to create image.");
        }
        this.m_image = i;
    }

    protected boolean isBlackAndWhite(BufferedImage image) {
        boolean result;
        if (image == null) {
            return false;
        }
        switch (image.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                result = false;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    @Override
    public String getDefiningString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.m_image, "png", baos);
        }
        catch (IOException e) {
            System.out.println("ImageProperty.getDefiningString error creating string.");
        }
        byte[] bs = baos.toByteArray();
        String result = Base64.getEncoder().encodeToString(bs);
        return result;
    }

    @Override
    public void accept(PropertyVisitor v) {
        v.visit(this);
    }

    @Override
    public BufferedImage getValue() {
        return this.m_image;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

