/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.properties;

import java.io.File;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyVisitor;

public class FileProperty
implements Property<File> {
    private File m_file = null;
    private String m_filename;
    private PropertyOwner m_owner;

    public FileProperty(PropertyOwner owner, String s) {
        this.m_owner = owner;
        OpticsProject p = PropertyManager.getInstance().getProject(this.m_owner);
        if (p == null) {
            this.m_filename = s;
            this.m_file = null;
        } else {
            this.m_file = PropertyManager.loadRelative(p.getFile(), s);
            if (this.m_file != null && this.m_file.exists()) {
                this.m_filename = null;
            }
        }
    }

    public FileProperty(PropertyOwner owner, File file) {
        this.m_owner = owner;
        this.m_file = file;
        this.m_filename = null;
    }

    public PropertyOwner getOwner() {
        return this.m_owner;
    }

    @Override
    public String getDefiningString() {
        String result = "";
        result = PropertyManager.getRelativePath(this.m_owner, this.getValue());
        return result;
    }

    @Override
    public void accept(PropertyVisitor v) {
        v.visit(this);
    }

    @Override
    public File getValue() {
        OpticsProject p;
        if (this.m_file == null && (p = PropertyManager.getInstance().getProject(this.m_owner)) != null) {
            this.m_file = PropertyManager.loadRelative(p.getFile(), this.m_filename);
            if (this.m_file != null && this.m_file.exists()) {
                this.m_filename = null;
            }
        }
        return this.m_file;
    }
}

