/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jocular.properties.ArrayProperty;
import net.sourceforge.jocular.properties.PropertyVisitor;

public class FileArrayProperty
extends ArrayProperty<File> {
    private final List<File> m_values = new ArrayList<File>();

    @Override
    protected String getSeparator() {
        return " ; ";
    }

    public FileArrayProperty(String s) {
        String[] ss;
        for (String ts : ss = this.split(s)) {
            this.m_values.add(new File(ts));
        }
    }

    public FileArrayProperty(File[] fs) {
        for (File f : fs) {
            this.m_values.add(f.getAbsoluteFile());
        }
    }

    @Override
    public void accept(PropertyVisitor v) {
        v.visit(this);
    }

    @Override
    public File[] getValue() {
        return this.m_values.toArray(new File[this.m_values.size()]);
    }

    @Override
    public String getDefiningString(int i) {
        return this.m_values.get(i).getAbsolutePath();
    }
}

