/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.properties;

import java.util.List;
import net.sourceforge.jocular.math.equations.BaseUnit;
import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.properties.CalculatedProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyVisitor;

public class EquationProperty
implements Property<UnitedValue>,
CalculatedProperty {
    UnitedValue m_unitedValue;
    String m_definingString;
    String m_variableName;

    public EquationProperty(String s, PropertyOwner po, PropertyKey pk) {
        this.m_definingString = s;
        this.m_unitedValue = UnitedValue.NAN;
        this.calcValue(po, pk);
    }

    public EquationProperty(double d) {
        this.m_definingString = Double.toString(d);
        this.m_unitedValue = UnitedValue.makeSimpleValue(BaseUnit.UNITLESS, d);
    }

    @Override
    public UnitedValue getValue() {
        return this.m_unitedValue;
    }

    public boolean isDeferred() {
        boolean result = false;
        UnitedValue uv = this.getValue();
        if (uv == null || uv.isDeferred()) {
            result = true;
        }
        return result;
    }

    @Override
    public String getDefiningString() {
        return this.m_definingString;
    }

    @Override
    public void accept(PropertyVisitor v) {
        v.visit(this);
    }

    @Override
    public void calcValue(PropertyOwner po, PropertyKey pk) {
        String n = EquationParser.getLeftHandSide(this.m_definingString);
        this.setVariableName(n);
        List<UnitedValue> uvs = PropertyManager.getInstance().parseEquation(this.m_definingString, po, pk);
        this.m_unitedValue = uvs.get(0);
        if (this.m_unitedValue.isError()) {
            System.out.println("EquationProperty.calcValue calculation error \"" + this.m_definingString + "\" for property: " + pk.name());
        }
    }

    public String toString() {
        return "EquationProperty(" + this.getDefiningString() + ")=" + this.m_unitedValue;
    }

    public void setVariableName(String n) {
        this.m_variableName = n;
    }

    public String getVariableName() {
        return this.m_variableName;
    }

    @Override
    public void undefer(PropertyOwner owner, PropertyKey key) {
        if (this.isDeferred()) {
            this.calcValue(owner, key);
        }
    }
}

