/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.properties;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.properties.ArrayProperty;
import net.sourceforge.jocular.properties.CalculatedProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyVisitor;

public class EquationArrayProperty
extends ArrayProperty<UnitedValue>
implements CalculatedProperty {
    private List<EquationProperty> m_equations = new ArrayList<EquationProperty>();

    public EquationArrayProperty(String s, PropertyOwner po, PropertyKey pk) {
        this(EquationParser.splitString(s), po, pk);
    }

    @Override
    protected String[] split(String s) {
        return EquationParser.splitString(s);
    }

    public EquationArrayProperty(String[] ss, PropertyOwner po, PropertyKey pk) {
        for (String s : ss) {
            this.m_equations.add(new EquationProperty(s, po, pk));
        }
    }

    @Override
    public UnitedValue[] getValue() {
        int n = this.getEquationCount();
        UnitedValue[] result = new UnitedValue[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.m_equations.get(i).getValue();
        }
        return result;
    }

    @Override
    public String getSeparator() {
        return ",";
    }

    @Override
    public void accept(PropertyVisitor v) {
        v.visit(this);
    }

    @Override
    public void calcValue(PropertyOwner po, PropertyKey pk) {
        for (EquationProperty ep : this.m_equations) {
            ep.calcValue(po, pk);
        }
    }

    public boolean isDeferred() {
        boolean result = false;
        for (UnitedValue v : this.getValue()) {
            if (!v.isDeferred()) continue;
            result = true;
        }
        return result;
    }

    public boolean isError() {
        boolean result = false;
        for (UnitedValue v : this.getValue()) {
            if (!v.isError()) continue;
            result = true;
        }
        return result;
    }

    @Override
    public String getDefiningString(int i) {
        return this.m_equations.get(i).getDefiningString();
    }

    public EquationProperty getEquation(int i) {
        return this.m_equations.get(i);
    }

    public EquationProperty[] getIndividualEquations(PropertyOwner owner, PropertyKey key, boolean onlyLhs) {
        return this.m_equations.toArray(new EquationProperty[this.m_equations.size()]);
    }

    public int getEquationCount() {
        return this.m_equations.size();
    }

    @Override
    public void undefer(PropertyOwner owner, PropertyKey key) {
        if (this.isDeferred()) {
            this.calcValue(owner, key);
        }
    }
}

