/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.properties;

import net.sourceforge.jocular.properties.ArrayProperty;
import net.sourceforge.jocular.properties.PropertyVisitor;

public class EnumArrayProperty
extends ArrayProperty<Enum<?>> {
    private final Enum<?>[] m_values;
    private final Enum<?> m_enumClass;

    public EnumArrayProperty(Enum<?> e, String[] ss) {
        this.m_enumClass = e;
        if (ss.length == 1 && ss[0] == "") {
            ss = new String[]{};
        }
        this.m_values = new Enum[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            this.m_values[i] = this.lookupEnumElement(ss[i]);
        }
    }

    public EnumArrayProperty(Enum<?> e, String s) {
        this.m_enumClass = e;
        String[] ss = this.split(s);
        int n = ss.length;
        this.m_values = new Enum[n];
        for (int i = 0; i < n; ++i) {
            this.m_values[i] = this.lookupEnumElement(ss[i]);
        }
    }

    @Override
    protected String getSeparator() {
        return ",";
    }

    @Override
    public Enum<?>[] getValue() {
        return this.m_values;
    }

    @Override
    public void accept(PropertyVisitor v) {
        v.visit(this);
    }

    @Override
    public String getDefiningString(int i) {
        return this.m_values[i].name();
    }

    protected Enum<?> lookupEnumElement(String definingString) {
        Enum result = null;
        String ds = definingString;
        if (ds.equals("")) {
            ds = ((Enum[])this.m_enumClass.getClass().getEnumConstants())[0].name();
        }
        for (Enum e1 : (Enum[])this.m_enumClass.getClass().getEnumConstants()) {
            if (!e1.name().equals(ds)) continue;
            result = e1;
            break;
        }
        if (result == null) {
            throw new RuntimeException("EnumProperty: \"" + definingString + "\" could not be found in enum");
        }
        return result;
    }
}

