/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import net.sourceforge.jocular.Jocular;
import net.sourceforge.jocular.JocularFileParsingException;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.OpticsPart;
import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.photons.PhotonWrangler;
import net.sourceforge.jocular.positioners.ObjectPositionerKey;
import net.sourceforge.jocular.project.GlobalVariables;
import net.sourceforge.jocular.project.ProjectUpdatedEvent;
import net.sourceforge.jocular.project.ProjectUpdatedListener;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.undo.OpticsEdit;
import net.sourceforge.jocular.undo.OpticsMoveEdit;
import net.sourceforge.jocular.undo.OpticsObjectEdit;
import net.sourceforge.jocular.undo.PositionerEdit;
import net.sourceforge.jocular.undo.PropertyEdit;
import net.sourceforge.jocular.xmlParser.JclXmlWriter;
import net.sourceforge.jocular.xmlParser.OpticsProjectXmlParser;

public class OpticsProject
implements TreeModel {
    private final ProjectRootGroup m_group;
    private final PhotonWrangler m_wrangler;
    private final GlobalVariables m_globalVars = new GlobalVariables(this);
    private String m_fileName = "";
    private final UndoManager m_undoManager = new UndoManager();
    private final Collection<TreeModelListener> m_listeners = new CopyOnWriteArrayList<TreeModelListener>();
    private final String m_version;
    private boolean m_dirtyFlag;
    private CopyOnWriteArrayList<ProjectUpdatedListener> m_ProjectUpdatedListeners = new CopyOnWriteArrayList();

    public OpticsProject() {
        this.m_group = new ProjectRootGroup();
        this.m_group.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
            }
        });
        this.m_wrangler = new PhotonWrangler();
        this.m_version = Jocular.getFormattedVersion();
        this.m_dirtyFlag = false;
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String m_fileName) {
        this.m_fileName = m_fileName;
    }

    public PhotonWrangler getWrangler() {
        return this.m_wrangler;
    }

    public ProjectRootGroup getOpticsObject() {
        return this.m_group;
    }

    public GlobalVariables getGlobalVariables() {
        return this.m_globalVars;
    }

    public boolean isDirty() {
        return this.m_dirtyFlag;
    }

    public Collection<OpticsObject> getFlattenedOpticsObjects(boolean includeSuppressedObjects) {
        return this.m_group.getFlattenedOpticsObjects(includeSuppressedObjects);
    }

    public void addOpticsObject(OpticsObject o) {
        this.m_group.addToEnd(o);
    }

    public void addRootGroup(ProjectRootGroup rGroup) {
        this.m_group.copyProperties(rGroup);
        this.m_group.setPositioner(rGroup.getPositioner().makeCopy());
        for (OpticsObject o : rGroup.getObjects()) {
            this.m_group.addToEnd(o);
        }
    }

    public String getUndoPresentationName() {
        return this.m_undoManager.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        return this.m_undoManager.getRedoPresentationName();
    }

    public void undo() {
        if (this.m_undoManager.canUndo()) {
            this.m_undoManager.undo();
            this.m_dirtyFlag = true;
        }
    }

    public void redo() {
        if (this.m_undoManager.canRedo()) {
            this.m_undoManager.redo();
            this.m_dirtyFlag = true;
        }
    }

    public void addPropertyEdit(PropertyOwner owner, PropertyKey key, String value) {
        this.addAndDoEdit(new PropertyEdit(this, owner, key, value));
    }

    public void addOpticsObjectEdit(OpticsObjectGroup group, OpticsObject toAdd, int pos, OpticsObject toRemove) {
        this.addAndDoEdit(new OpticsObjectEdit(group, toAdd, pos, toRemove, this));
    }

    public void addPositionerEdit(OpticsObject object, ObjectPositionerKey key) {
        this.addAndDoEdit(new PositionerEdit(object, key, this));
    }

    public void addObjectMoveEdit(OpticsObjectGroup group, OpticsObject object, boolean upNotDown) {
        this.addAndDoEdit(new OpticsMoveEdit(this, group, object, upNotDown));
    }

    public void addAndDoEdit(OpticsEdit u) {
        if (u.getProject() != this) {
            throw new RuntimeException("Project in Edit does not match this one.");
        }
        u.redo();
        this.m_undoManager.addEdit(u);
        this.m_dirtyFlag = true;
        this.fireProjectUpdated(new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.CHANGE));
    }

    public boolean canUndo() {
        return this.m_undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.m_undoManager.canRedo();
    }

    public void save() {
        JclXmlWriter writer = new JclXmlWriter(this.m_fileName);
        writer.visit(this);
        this.m_dirtyFlag = false;
        this.fireProjectUpdated(new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.SAVE));
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.m_listeners.add(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        OpticsObject result = null;
        if (parent instanceof OpticsObjectGroup && !(parent instanceof OpticsPart)) {
            OpticsObjectGroup g = (OpticsObjectGroup)parent;
            OpticsObject[] os = g.getObjects().toArray(new OpticsObject[g.getObjects().size()]);
            result = os[index];
        }
        return result;
    }

    @Override
    public int getChildCount(Object parent) {
        int result = 0;
        if (parent instanceof OpticsObjectGroup && !(parent instanceof OpticsPart)) {
            OpticsObjectGroup g = (OpticsObjectGroup)parent;
            result = g.getObjects().size();
        }
        return result;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int result = -1;
        if (parent instanceof OpticsObjectGroup && !(parent instanceof OpticsPart)) {
            OpticsObjectGroup g = (OpticsObjectGroup)parent;
            OpticsObject[] os = g.getObjects().toArray(new OpticsObject[g.getObjects().size()]);
            for (int i = 0; i < os.length; ++i) {
                if (os[i] != child) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    @Override
    public Object getRoot() {
        return this.m_group;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof OpticsObjectGroup) || node instanceof OpticsPart;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.m_listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        for (TreeModelListener l : this.m_listeners) {
            l.treeNodesChanged(new TreeModelEvent(newValue, path));
        }
    }

    public void fireNodeUpdate(OpticsObject o, OpticsObjectGroup g, NodeUpdateType type, int index) {
        int[] childIndices = new int[]{index};
        Object[] os = new Object[]{o};
        Object[] path = new Object[]{};
        if (g != null) {
            path = this.getPath(g);
        }
        TreeModelEvent e = new TreeModelEvent((Object)o, path, childIndices, os);
        for (TreeModelListener l : this.m_listeners) {
            switch (type) {
                case ADD: {
                    l.treeNodesInserted(e);
                    break;
                }
                case REMOVE: {
                    l.treeNodesRemoved(e);
                    break;
                }
                case CHANGE: {
                    l.treeNodesChanged(e);
                }
            }
        }
    }

    public OpticsObject[] getPath(OpticsObject o) {
        ArrayList<OpticsObject> result = new ArrayList<OpticsObject>();
        this.getPath(result, o, this.m_group);
        return result.toArray(new OpticsObject[result.size()]);
    }

    protected boolean getPath(ArrayList<OpticsObject> list, OpticsObject o, OpticsObject path) {
        boolean result = false;
        if (o == path) {
            list.add(0, path);
            result = true;
        } else if (path instanceof OpticsObjectGroup) {
            OpticsObjectGroup g = (OpticsObjectGroup)path;
            for (OpticsObject oTest : g.getObjects()) {
                if (!this.getPath(list, o, oTest)) continue;
                list.add(0, g);
                result = true;
            }
        }
        return result;
    }

    public void fireStructureUpdate() {
    }

    public void stopWrangler() {
        this.m_wrangler.stop();
    }

    public void addProjectUpdatedListener(ProjectUpdatedListener listener) {
        this.m_ProjectUpdatedListeners.addIfAbsent(listener);
    }

    public void fireProjectUpdated(ProjectUpdatedEvent type) {
        for (ProjectUpdatedListener listener : this.m_ProjectUpdatedListeners) {
            listener.projectUpdated(type);
        }
    }

    public static OpticsProject loadProject(File selectedFile) {
        OpticsProject result;
        if (selectedFile == null || !selectedFile.exists()) {
            return null;
        }
        try {
            result = OpticsProjectXmlParser.parseProjectFile(selectedFile.getPath());
        }
        catch (IOException | JocularFileParsingException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            return null;
        }
        return result;
    }

    public File getFile() {
        return new File(this.getFileName());
    }

    public boolean isObjectInProject(OpticsObject oo) {
        OpticsObject[] path = this.getPath(oo);
        return path.length > 0;
    }

    public static enum NodeUpdateType {
        ADD,
        REMOVE,
        CHANGE;

    }
}

