/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.project;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;

public class GlobalVariables
implements TableModel {
    CopyOnWriteArrayList<TableModelListener> m_listeners = new CopyOnWriteArrayList();
    private final OpticsProject m_project;

    protected GlobalVariables(OpticsProject project) {
        this.m_project = project;
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.m_listeners.addIfAbsent(listener);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class<String> result = null;
        switch (this.getColumn(column)) {
            case NAME: {
                result = String.class;
                break;
            }
            case EQUATION: {
                result = String.class;
                break;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public String getColumnName(int column) {
        String result;
        Column c = this.getColumn(column);
        switch (c) {
            case NAME: 
            case EQUATION: {
                result = c.name();
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        return this.getEquationProperties().length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String result = null;
        EquationProperty[] eps = this.getEquationProperties();
        if (row < eps.length && row >= 0) {
            String ds = eps[row].getDefiningString();
            switch (this.getColumn(column)) {
                case EQUATION: {
                    result = EquationParser.getRightHandSide(ds);
                    break;
                }
                case NAME: {
                    result = EquationParser.getLeftHandSide(ds);
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        boolean result = false;
        EquationProperty[] eps = this.getEquationProperties();
        Column c = this.getColumn(column);
        if (row < eps.length) {
            result = true;
        }
        return result;
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        ProjectRootGroup oo;
        Property<?> prop;
        Object v = value.toString();
        if (value instanceof EquationProperty) {
            v = ((EquationProperty)value).getDefiningString();
        }
        if ((prop = (oo = this.getOwner()).getProperty(PropertyKey.VARIABLES)) instanceof EquationArrayProperty) {
            EquationArrayProperty eap = (EquationArrayProperty)prop;
            EquationProperty ep = eap.getIndividualEquations(oo, PropertyKey.VARIABLES, false)[row];
            switch (Column.values()[column]) {
                case EQUATION: {
                    v = EquationParser.getLeftHandSide(ep.getDefiningString()) + "=" + (String)v;
                    break;
                }
                case NAME: {
                    v = (String)v + "=" + EquationParser.getRightHandSide(ep.getDefiningString());
                }
            }
            String s = eap.replaceRowInDefiningString(row, (String)v);
            this.m_project.addPropertyEdit(oo, PropertyKey.VARIABLES, s);
        }
    }

    private EquationProperty[] getEquationProperties() {
        EquationProperty[] result = new EquationProperty[]{};
        ProjectRootGroup oo = this.getOwner();
        Property<?> prop = oo.getProperty(PropertyKey.VARIABLES);
        if (prop instanceof EquationArrayProperty) {
            EquationArrayProperty eap = (EquationArrayProperty)prop;
            result = eap.getIndividualEquations(oo, PropertyKey.VARIABLES, false);
        }
        return result;
    }

    private Column getColumn(int i) {
        Column result = null;
        if (i < Column.values().length) {
            result = Column.values()[i];
        }
        return result;
    }

    private ProjectRootGroup getOwner() {
        return this.m_project.getOpticsObject();
    }

    public void add(int i) {
        ProjectRootGroup oo = this.getOwner();
        EquationArrayProperty eap = (EquationArrayProperty)oo.getProperty(PropertyKey.VARIABLES);
        if (eap == null) {
            eap = new EquationArrayProperty("0", (PropertyOwner)oo, PropertyKey.VARIABLES);
        }
        this.m_project.addPropertyEdit(oo, PropertyKey.VARIABLES, eap.addRowToDefiningString(i));
        this.fireTableChanged();
    }

    public void remove(int i) {
        ProjectRootGroup oo = this.getOwner();
        EquationArrayProperty eap = (EquationArrayProperty)oo.getProperty(PropertyKey.VARIABLES);
        if (eap == null) {
            eap = new EquationArrayProperty("", (PropertyOwner)oo, PropertyKey.VARIABLES);
        }
        this.m_project.addPropertyEdit(oo, PropertyKey.VARIABLES, eap.removeRowFromDefiningString(i));
        this.fireTableChanged();
    }

    private void fireTableChanged() {
        TableModelEvent tme = new TableModelEvent(this);
        for (TableModelListener l : this.m_listeners) {
            l.tableChanged(tme);
        }
    }

    private static enum Column {
        NAME,
        EQUATION;

    }
}

