/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.positioners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.positioners.AbstractPositioner;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.project.OpticsPositionerVisitor;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;

public class TranslateRotatePositioner
extends AbstractPositioner {
    EquationProperty m_dirOffsetValue = new EquationProperty("0", this, PropertyKey.DIR_OFFSET);
    EquationProperty m_transOffsetValue = new EquationProperty("0", this, PropertyKey.TRANS_OFFSET);
    EquationProperty m_orthoOffsetValue = new EquationProperty("0", this, PropertyKey.ORTHO_OFFSET);
    EquationProperty m_dirAngleValue = new EquationProperty("0", this, PropertyKey.DIR_ANGLE);
    EquationProperty m_transAngleValue = new EquationProperty("0", this, PropertyKey.TRANS_ANGLE);
    EquationProperty m_orthoAngleValue = new EquationProperty("0", this, PropertyKey.ORTHO_ANGLE);

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case DIR_OFFSET: {
                this.m_dirOffsetValue = new EquationProperty(s, this, key);
                break;
            }
            case TRANS_OFFSET: {
                this.m_transOffsetValue = new EquationProperty(s, this, key);
                break;
            }
            case ORTHO_OFFSET: {
                this.m_orthoOffsetValue = new EquationProperty(s, this, key);
                break;
            }
            case DIR_ANGLE: {
                this.m_dirAngleValue = new EquationProperty(s, this, key);
                break;
            }
            case TRANS_ANGLE: {
                this.m_transAngleValue = new EquationProperty(s, this, key);
                break;
            }
            case ORTHO_ANGLE: {
                this.m_orthoAngleValue = new EquationProperty(s, this, key);
                break;
            }
        }
        this.firePropertyUpdated(key);
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        EquationProperty result;
        switch (key) {
            case DIR_OFFSET: {
                result = this.m_dirOffsetValue;
                break;
            }
            case TRANS_OFFSET: {
                result = this.m_transOffsetValue;
                break;
            }
            case ORTHO_OFFSET: {
                result = this.m_orthoOffsetValue;
                break;
            }
            case DIR_ANGLE: {
                result = this.m_dirAngleValue;
                break;
            }
            case TRANS_ANGLE: {
                result = this.m_transAngleValue;
                break;
            }
            case ORTHO_ANGLE: {
                result = this.m_orthoAngleValue;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.DIR_OFFSET, PropertyKey.TRANS_OFFSET, PropertyKey.ORTHO_OFFSET, PropertyKey.DIR_ANGLE, PropertyKey.TRANS_ANGLE, PropertyKey.ORTHO_ANGLE));
        return result;
    }

    @Override
    public ObjectPositioner makeCopy() {
        TranslateRotatePositioner result = new TranslateRotatePositioner();
        result.copyProperties(this);
        return result;
    }

    @Override
    public Vector3D calcOrigin(ObjectPositioner parentPositioner) {
        Vector3D dir = parentPositioner.getDirection().scale(this.m_dirOffsetValue.getValue().getBaseUnitValue());
        Vector3D trans = parentPositioner.getTransDirection().scale(this.m_transOffsetValue.getValue().getBaseUnitValue());
        Vector3D ortho = parentPositioner.getOrthoDirection().scale(this.m_orthoOffsetValue.getValue().getBaseUnitValue());
        Vector3D origin = parentPositioner.getOrigin();
        origin = origin.add(dir).add(trans).add(ortho);
        return origin;
    }

    @Override
    protected Vector3D calcDirection(ObjectPositioner parent) {
        Vector3D result = parent.getDirection();
        result = result.rotate(parent.getDirection(), this.m_dirAngleValue.getValue().getBaseUnitValue());
        result = result.rotate(parent.getTransDirection(), this.m_transAngleValue.getValue().getBaseUnitValue());
        result = result.rotate(parent.getOrthoDirection(), this.m_orthoAngleValue.getValue().getBaseUnitValue());
        return result;
    }

    @Override
    protected Vector3D calcTransDirection(ObjectPositioner parent) {
        Vector3D result = parent.getTransDirection();
        result = result.rotate(parent.getDirection(), this.m_dirAngleValue.getValue().getBaseUnitValue());
        result = result.rotate(parent.getTransDirection(), this.m_transAngleValue.getValue().getBaseUnitValue());
        result = result.rotate(parent.getOrthoDirection(), this.m_orthoAngleValue.getValue().getBaseUnitValue());
        return result;
    }

    @Override
    protected Vector3D calcOrthoDirection(ObjectPositioner parent) {
        Vector3D result = parent.getOrthoDirection();
        result = result.rotate(parent.getDirection(), this.m_dirAngleValue.getValue().getBaseUnitValue());
        result = result.rotate(parent.getTransDirection(), this.m_transAngleValue.getValue().getBaseUnitValue());
        result = result.rotate(parent.getOrthoDirection(), this.m_orthoAngleValue.getValue().getBaseUnitValue());
        return result;
    }

    @Override
    public void accept(OpticsPositionerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected Transform calcTransform(ObjectPositioner parent) {
        Transform result = parent.getTransform();
        double dx = this.m_orthoOffsetValue.getValue().getBaseUnitValue();
        double dy = this.m_transOffsetValue.getValue().getBaseUnitValue();
        double dz = this.m_dirOffsetValue.getValue().getBaseUnitValue();
        result = result.createConcatenation(new Translate(dx, dy, dz));
        double dirDeg = Math.toDegrees(this.m_dirAngleValue.getValue().getBaseUnitValue());
        double transDeg = Math.toDegrees(this.m_transAngleValue.getValue().getBaseUnitValue());
        double orthoDeg = Math.toDegrees(this.m_orthoAngleValue.getValue().getBaseUnitValue());
        result = result.createConcatenation(new Rotate(transDeg, parent.getTransDirection().toPoint3D()));
        result = result.createConcatenation(new Rotate(orthoDeg, parent.getOrthoDirection().toPoint3D()));
        result = result.createConcatenation(new Rotate(dirDeg, parent.getDirection().toPoint3D()));
        return result;
    }
}

