/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.positioners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.positioners.AbstractPositioner;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.project.OpticsPositionerVisitor;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;

public class OffsetPositioner
extends AbstractPositioner {
    EquationProperty m_offsetValue = new EquationProperty(0.0);

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case DIR_OFFSET: {
                this.m_offsetValue = new EquationProperty(s, this, key);
                break;
            }
        }
        this.firePropertyUpdated(key);
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        EquationProperty result;
        switch (key) {
            case DIR_OFFSET: {
                result = this.m_offsetValue;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.DIR_OFFSET));
        return result;
    }

    @Override
    public Vector3D calcOrigin(ObjectPositioner parentPositioner) {
        return parentPositioner.getDirection().scale(this.m_offsetValue.getValue().getBaseUnitValue()).add(parentPositioner.getOrigin());
    }

    @Override
    protected Transform calcTransform(ObjectPositioner parent) {
        Transform result = parent.getTransform();
        result = result.createConcatenation(new Translate(0.0, 0.0, this.m_offsetValue.getValue().getBaseUnitValue()));
        return result;
    }

    @Override
    public ObjectPositioner makeCopy() {
        OffsetPositioner result = new OffsetPositioner();
        result.copyProperties(this);
        return result;
    }

    @Override
    public void accept(OpticsPositionerVisitor visitor) {
        visitor.visit(this);
    }
}

