/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.positioners;

import net.sourceforge.jocular.positioners.AnglePositioner;
import net.sourceforge.jocular.positioners.AxisPositioner;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.positioners.OffsetPositioner;
import net.sourceforge.jocular.positioners.ReverseOffsetPositioner;
import net.sourceforge.jocular.positioners.TranslateRotatePositioner;
import net.sourceforge.jocular.positioners.TransverseOffsetPositioner;

public enum ObjectPositionerKey {
    AXIS("Axis", new AxisPositioner(), "Positions on an axis(X, Y, Z) at the origin."),
    OFFSET("Offset", new OffsetPositioner(), "Positions this object a distance along the direction of the parent positioner."),
    REVERSE_OFFSET("Offset and reverse", new ReverseOffsetPositioner(), "Positions this object a distance along the direction of the parent positioner and reverses the direction."),
    TRANSVERSE_OFFSET("Transverse Offset", new TransverseOffsetPositioner(), "Offsets the object transversely a specified distance off the direction of the parent positioner."),
    ANGLE("Angle", new AnglePositioner(), "Rotates the object about one of its axes"),
    TRANSLATE_ROTATE("Translate & Rotate", new TranslateRotatePositioner(), "Translates the object in 3-space then rotates about 3 axes");

    private String name;
    private ObjectPositioner prototype;
    private String tooltip;

    private ObjectPositionerKey(String n2, ObjectPositioner o, String t) {
        this.name = n2;
        this.prototype = o;
        this.tooltip = t;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public ObjectPositioner getNewPositioner() {
        return this.prototype.makeCopy();
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public static ObjectPositionerKey getKey(ObjectPositioner p) {
        ObjectPositionerKey result = null;
        for (ObjectPositionerKey k : ObjectPositionerKey.values()) {
            if (k.prototype.getClass() != p.getClass()) continue;
            result = k;
            break;
        }
        return result;
    }

    public static String getKeyName(ObjectPositioner p) {
        String result = null;
        for (ObjectPositionerKey k : ObjectPositionerKey.values()) {
            if (k.prototype.getClass() != p.getClass()) continue;
            result = k.name();
            break;
        }
        return result;
    }

    public static ObjectPositionerKey getKey(String positionerToMatch) {
        for (ObjectPositionerKey key : ObjectPositionerKey.values()) {
            if (!positionerToMatch.equals(key.name())) continue;
            return key;
        }
        return null;
    }
}

