/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.positioners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.positioners.AbstractPositioner;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.project.OpticsPositionerVisitor;
import net.sourceforge.jocular.properties.EnumProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;

public class AxisPositioner
extends AbstractPositioner {
    private EnumProperty m_axisProperty = new EnumProperty(AxisType.Z, AxisType.Z.name());

    public AxisPositioner() {
        this.update(null);
        this.setProperty(PropertyKey.AXIS, AxisType.Z.name());
    }

    public AxisPositioner(String s) {
        this.update(null);
        this.setProperty(PropertyKey.AXIS, s);
    }

    @Override
    public ObjectPositioner makeCopy() {
        AxisPositioner result = new AxisPositioner();
        result.copyProperties(this);
        return result;
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case AXIS: {
                this.m_axisProperty = new EnumProperty(AxisType.X, s);
                break;
            }
        }
        this.firePropertyUpdated(key);
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        EnumProperty result;
        switch (key) {
            case AXIS: {
                result = this.m_axisProperty;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.AXIS));
        return result;
    }

    @Override
    public void accept(OpticsPositionerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Vector3D calcOrigin(ObjectPositioner parentPositioner) {
        Vector3D result;
        switch ((AxisType)((Object)this.m_axisProperty.getValue())) {
            case X: {
                result = new Vector3D(0.0, 0.0, 0.0);
                break;
            }
            case Y: {
                result = new Vector3D(0.0, 0.0, 0.0);
                break;
            }
            default: {
                result = new Vector3D(0.0, 0.0, 0.0);
            }
        }
        return result;
    }

    @Override
    public Vector3D calcDirection(ObjectPositioner parentPositioner) {
        Vector3D result;
        switch ((AxisType)((Object)this.m_axisProperty.getValue())) {
            case X: {
                result = new Vector3D(1.0, 0.0, 0.0);
                break;
            }
            case Y: {
                result = new Vector3D(0.0, 1.0, 0.0);
                break;
            }
            default: {
                result = new Vector3D(0.0, 0.0, 1.0);
            }
        }
        return result;
    }

    @Override
    public Vector3D calcTransDirection(ObjectPositioner parentPositioner) {
        Vector3D result;
        switch ((AxisType)((Object)this.m_axisProperty.getValue())) {
            case X: {
                result = new Vector3D(0.0, 0.0, 1.0);
                break;
            }
            case Y: {
                result = new Vector3D(1.0, 0.0, 0.0);
                break;
            }
            default: {
                result = new Vector3D(0.0, 1.0, 0.0);
            }
        }
        return result;
    }

    @Override
    protected Transform calcTransform(ObjectPositioner parent) {
        Rotate result;
        switch ((AxisType)((Object)this.m_axisProperty.getValue())) {
            case X: {
                result = new Rotate(90.0, Vector3D.Y_AXIS.toPoint3D());
                break;
            }
            case Y: {
                result = new Rotate(90.0, Vector3D.X_AXIS.toPoint3D());
                break;
            }
            default: {
                result = new Rotate();
            }
        }
        return result;
    }

    public static enum AxisType {
        X,
        Y,
        Z;

    }
}

