/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.positioners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Point3D;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.positioners.AbstractPositioner;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.project.OpticsPositionerVisitor;
import net.sourceforge.jocular.properties.EnumProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;

public class AnglePositioner
extends AbstractPositioner {
    private EquationProperty m_angle = new EquationProperty(0.0);
    private EquationProperty m_dirOffset = new EquationProperty(0.0);
    private EnumProperty m_axis = new EnumProperty(Axis.DIR_AXIS, Axis.DIR_AXIS.name());
    private Vector3D m_v;

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case DIR_OFFSET: {
                this.m_dirOffset = new EquationProperty(s, this, key);
                break;
            }
            case ROT_AXIS: {
                this.m_axis = new EnumProperty(Axis.DIR_AXIS, s);
                this.calcMembers();
                break;
            }
            case ANGLE: {
                this.m_angle = new EquationProperty(s, this, key);
                break;
            }
        }
        this.firePropertyUpdated(key);
    }

    public AnglePositioner() {
        this.calcMembers();
    }

    private void calcMembers() {
        this.m_v = ((Axis)((Object)this.m_axis.getValue())).getVector();
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result = null;
        switch (key) {
            case DIR_OFFSET: {
                result = this.m_dirOffset;
                break;
            }
            case ROT_AXIS: {
                result = this.m_axis;
                break;
            }
            case ANGLE: {
                result = this.m_angle;
                break;
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.ROT_AXIS, PropertyKey.ANGLE, PropertyKey.DIR_OFFSET));
        return result;
    }

    @Override
    protected Vector3D calcOrigin(ObjectPositioner parentPositioner) {
        return parentPositioner.getDirection().scale(this.m_dirOffset.getValue().getBaseUnitValue()).add(parentPositioner.getOrigin());
    }

    @Override
    protected Vector3D calcDirection(ObjectPositioner parentPositioner) {
        Vector3D result = parentPositioner.getDirection();
        Point3D p = this.getTransform().transform(Vector3D.DIR.toPoint3D());
        result = result.rotate(this.m_v, this.m_angle.getValue().getBaseUnitValue());
        return result;
    }

    @Override
    protected Vector3D calcTransDirection(ObjectPositioner parentPositioner) {
        Vector3D result = parentPositioner.getTransDirection();
        result = result.rotate(this.m_v, this.m_angle.getValue().getBaseUnitValue());
        return result;
    }

    @Override
    public ObjectPositioner makeCopy() {
        AnglePositioner result = new AnglePositioner();
        result.copyProperties(this);
        return result;
    }

    @Override
    public void accept(OpticsPositionerVisitor v) {
        v.visit(this);
    }

    @Override
    protected Transform calcTransform(ObjectPositioner parent) {
        Point3D axis;
        Transform result = parent.getTransform();
        result = result.createConcatenation(new Translate(0.0, 0.0, this.m_dirOffset.getValue().getBaseUnitValue()));
        double deg = Math.toDegrees(this.m_angle.getValue().getBaseUnitValue());
        Axis a = (Axis)((Object)this.m_axis.getValue());
        switch (a) {
            default: {
                axis = parent.getDirection().toPoint3D().multiply(-1.0);
                break;
            }
            case ORTHO_AXIS: {
                axis = parent.getOrthoDirection().toPoint3D().multiply(-1.0);
                break;
            }
            case TRANS_AXIS: {
                axis = parent.getTransDirection().toPoint3D();
            }
        }
        result = result.createConcatenation(new Rotate(deg, axis));
        return result;
    }

    public static enum Axis {
        DIR_AXIS("Dir.", Vector3D.DIR),
        TRANS_AXIS("Trans.", Vector3D.TRANS),
        ORTHO_AXIS("Ortho.", Vector3D.ORTHO);

        private String m_name;
        private Vector3D m_vector;

        private Axis(String name, Vector3D v) {
            this.m_name = name;
            this.m_vector = v;
        }

        public Vector3D getVector() {
            return this.m_vector;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

