/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.positioners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.objects.OpticsID;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.properties.CalculatedProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;

public abstract class AbstractPositioner
implements ObjectPositioner {
    private OpticsID m_id = new OpticsID();
    private Collection<PropertyUpdatedListener> m_propertyUpdatedListeners = new ArrayList<PropertyUpdatedListener>();
    private Vector3D m_origin = Vector3D.ORIGIN;
    private Vector3D m_direction = Vector3D.Z_AXIS;
    private Vector3D m_transDirection = Vector3D.Y_AXIS;
    private Vector3D m_orthoDirection = Vector3D.X_AXIS;
    private Transform m_transform = new Affine();

    @Override
    public void copyProperty(PropertyOwner owner, PropertyKey k) {
        Property<?> p = owner.getProperty(k);
        if (p == null) {
            return;
        }
        String s = p.getDefiningString();
        if (s == null) {
            throw new RuntimeException("s is null");
        }
        this.setProperty(k, s);
    }

    @Override
    public void copyProperties(PropertyOwner owner) {
        for (PropertyKey k : this.getPropertyKeys()) {
            this.copyProperty(owner, k);
        }
    }

    protected Vector3D calcOrigin(ObjectPositioner parentPositioner) {
        return parentPositioner.getOrigin();
    }

    protected Vector3D calcDirection(ObjectPositioner parentPositioner) {
        return parentPositioner.getDirection();
    }

    protected Vector3D calcTransDirection(ObjectPositioner parentPositioner) {
        return parentPositioner.getTransDirection();
    }

    protected Vector3D calcOrthoDirection(ObjectPositioner parentPositioner) {
        return Vector3D.getOrtho(this.m_direction, this.m_transDirection);
    }

    protected Transform calcTransform(ObjectPositioner parent) {
        return parent.getTransform();
    }

    @Override
    public void update(ObjectPositioner parentPositioner) {
        this.m_origin = this.calcOrigin(parentPositioner);
        this.m_direction = this.calcDirection(parentPositioner);
        this.m_transDirection = this.calcTransDirection(parentPositioner);
        this.m_orthoDirection = this.calcOrthoDirection(parentPositioner);
        this.m_transform = this.calcTransform(parentPositioner);
        if (this.m_origin == null) {
            throw new RuntimeException("AbstractObjectPositioner.update() origin is null");
        }
    }

    @Override
    public void addPropertyUpdatedListener(PropertyUpdatedListener listener) {
        if (!this.m_propertyUpdatedListeners.contains(listener)) {
            this.m_propertyUpdatedListeners.add(listener);
        }
    }

    @Override
    public void removePropertyUpdatedListener(PropertyUpdatedListener listener) {
        this.m_propertyUpdatedListeners.remove(listener);
    }

    @Override
    public void firePropertyUpdated(PropertyKey key) {
        PropertyUpdatedEvent e = new PropertyUpdatedEvent(this, key);
        for (PropertyUpdatedListener listener : this.m_propertyUpdatedListeners) {
            listener.propertyUpdated(e);
        }
    }

    @Override
    public Transform getTransform() {
        return this.m_transform;
    }

    @Override
    public Vector3D getOrigin() {
        return this.m_origin;
    }

    @Override
    public Vector3D getDirection() {
        return this.m_direction;
    }

    @Override
    public Vector3D getTransDirection() {
        return this.m_transDirection;
    }

    @Override
    public Vector3D getOrthoDirection() {
        return this.m_orthoDirection;
    }

    @Override
    public OpticsID getID() {
        return this.m_id;
    }

    @Override
    public void setID(OpticsID id) {
        this.m_id = id;
    }

    @Override
    public Vector3D transform(Vector3D p) {
        Vector3D result = this.getOrigin();
        result = result.add(this.getDirection().scale(p.z));
        result = result.add(this.getTransDirection().scale(p.y));
        result = result.add(this.getOrthoDirection().scale(p.x));
        return result;
    }

    @Override
    public Vector3D untransform(Vector3D p) {
        Vector3D d = p.subtract(this.getOrigin());
        double x = d.dot(this.getOrthoDirection());
        double y = d.dot(this.getTransDirection());
        double z = d.dot(this.getDirection());
        return new Vector3D(x, y, z);
    }

    @Override
    public List<Property<?>> getProperties() {
        ArrayList result = new ArrayList();
        for (PropertyKey pk : this.getPropertyKeys()) {
            result.add(this.getProperty(pk));
        }
        return result;
    }

    @Override
    public boolean isSame(OpticsObject o) {
        return o.getPositioner() == this;
    }

    @Override
    public void doInternalCalcs() {
        for (PropertyKey pk : this.getPropertyKeys()) {
            Property<?> p = this.getProperty(pk);
            if (!(p instanceof CalculatedProperty)) continue;
            CalculatedProperty cp = (CalculatedProperty)((Object)p);
            cp.calcValue(this, pk);
        }
    }
}

