/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.photons;

import net.sourceforge.jocular.math.ProbabilityResolver;
import net.sourceforge.jocular.math.Vector3D;

public class Polarization {
    private final Vector3D m_dirA;
    private final Vector3D m_dirB;
    private final double m_magA;
    private final double m_magB;
    private final double m_phaseA;
    private final double m_phaseB;

    public Polarization(Vector3D a, Vector3D b, double magA, double magB, double pa, double pb) {
        this.m_dirA = a.normalize();
        this.m_dirB = b.normalize();
        this.m_magA = magA;
        this.m_magB = magB;
        this.m_phaseA = pa;
        this.m_phaseB = pb;
        if (Math.abs(this.m_dirA.dot(this.m_dirB)) > 1.0E-10) {
            throw new RuntimeException("Polarization vectors are not orthogonal");
        }
        if (Math.abs(magA * magA + magB * magB - 1.0) > 1.0E-10) {
            System.out.println("Polarization() Magnitude of vectors is not 1. A: " + magA + ", B: " + magB);
            double m = Math.sqrt(magA * magA + magB * magB);
            magA /= m;
            magB /= m;
        }
    }

    public Polarization rotate(Vector3D v) {
        double vB;
        double vA = v.dot(this.m_dirA);
        double m2 = vA * vA + (vB = v.dot(this.m_dirB)) * vB;
        if (m2 < 1.0E-12) {
            return this;
        }
        Vector3D par = this.m_dirA.scale(vA).add(this.m_dirB.scale(vB)).normalize();
        Vector3D normal = Vector3D.getDir(this.m_dirA, this.m_dirB);
        Vector3D perp = Vector3D.getOrtho(normal, par);
        double aPar = par.dot(this.m_dirA) * this.m_magA;
        double bPar = par.dot(this.m_dirB) * this.m_magB;
        double aPerp = perp.dot(this.m_dirA) * this.m_magA;
        double bPerp = perp.dot(this.m_dirB) * this.m_magB;
        double parComp = this.ampSinAdd(aPar, bPar, this.m_phaseA, this.m_phaseB);
        double parPhase = this.phaseSinAdd(aPar, bPar, this.m_phaseA, this.m_phaseB);
        double perpComp = this.ampSinAdd(aPerp, bPerp, this.m_phaseA, this.m_phaseB);
        double perpPhase = this.phaseSinAdd(aPerp, bPerp, this.m_phaseA, this.m_phaseB);
        return new Polarization(par, perp, parComp, perpComp, parPhase, perpPhase);
    }

    private double ampSinAdd(double amp1, double amp2, double phase1, double phase2) {
        double a1 = Math.abs(amp1);
        double a2 = Math.abs(amp2);
        double p1 = amp1 >= 0.0 ? phase1 : phase1 + Math.PI;
        double p2 = amp2 >= 0.0 ? phase2 : phase2 + Math.PI;
        return Math.sqrt(a1 * a1 + a2 * a2 + 2.0 * a1 * a2 * Math.cos(p1 - p2));
    }

    private double phaseSinAdd(double amp1, double amp2, double phase1, double phase2) {
        double a1 = Math.abs(amp1);
        double a2 = Math.abs(amp2);
        double p1 = amp1 >= 0.0 ? phase1 : phase1 + Math.PI;
        double p2 = amp2 >= 0.0 ? phase2 : phase2 + Math.PI;
        return Math.atan2(a1 * Math.sin(p1) + a2 * Math.sin(p2), a1 * Math.cos(p1) + a2 * Math.cos(p2));
    }

    public double getMagA() {
        return this.m_magA;
    }

    public double getMagB() {
        return this.m_magB;
    }

    public Vector3D getDirA() {
        return this.m_dirA;
    }

    public Vector3D getDirB() {
        return this.m_dirB;
    }

    public double getPhaseA() {
        return this.m_phaseA;
    }

    public double getPhaseB() {
        return this.m_phaseB;
    }

    public Polarization resolveOntoAxis(Vector3D trans) {
        Polarization pol = this.rotate(trans);
        double magA = pol.getMagA();
        pol = ProbabilityResolver.resolve(magA * magA) ? new Polarization(pol.getDirA(), pol.getDirB(), 1.0, 0.0, pol.getPhaseA(), pol.getPhaseB()) : new Polarization(pol.getDirA(), pol.getDirB(), 0.0, 1.0, pol.getPhaseA(), pol.getPhaseB());
        return pol;
    }
}

