/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.photons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.jocular.autofocus.AutofocusSensor;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.photons.WranglerEvent;
import net.sourceforge.jocular.photons.WranglerListener;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.settings.Settings;
import net.sourceforge.jocular.sources.LightSource;
import net.sourceforge.jocular.splines.RotatedSpline;
import net.sourceforge.jocular.splines.RotatedSplineInteractionCalculator;

public class PhotonWrangler {
    private List<PhotonTrajectory> m_trajectories;
    private Collection<WranglerListener> m_WranglerListeners = new ArrayList<WranglerListener>();
    private int m_numTraj = Settings.SETTINGS.getPhotonTrajectoryCount();
    private int m_curTraj;
    private Thread[] wranglerThreads;
    public static final int NUM_THREADS = 1;
    public int m_wrangleCount = 0;
    private boolean stopWranglerThread;

    public PhotonWrangler() {
        this.m_trajectories = new LimitedQueue<PhotonTrajectory>(Settings.SETTINGS.getPhotonTrajectoryDisplayCount());
    }

    private List<LightSource> getLightSources(Collection<OpticsObject> os) {
        ArrayList<LightSource> result = new ArrayList<LightSource>();
        for (OpticsObject ot : os) {
            if (!(ot instanceof LightSource)) continue;
            result.add((LightSource)ot);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PhotonTrajectory> getTrajectories() {
        ArrayList<PhotonTrajectory> result;
        PhotonWrangler photonWrangler = this;
        synchronized (photonWrangler) {
            result = new ArrayList<PhotonTrajectory>(this.m_trajectories);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.isWrangling()) {
            throw new RuntimeException("Can't clear trajectories while running.");
        }
        PhotonWrangler photonWrangler = this;
        synchronized (photonWrangler) {
            this.m_trajectories = new LimitedQueue<PhotonTrajectory>(Settings.SETTINGS.getPhotonTrajectoryDisplayCount());
        }
        this.m_curTraj = 0;
        this.fireWranglerEvent(WranglerEvent.Type.FINISHED);
    }

    public boolean isWrangling() {
        boolean result = false;
        if (this.m_wrangleCount == 0) {
            result = false;
        } else if (this.wranglerThreads != null) {
            for (Thread t : this.wranglerThreads) {
                if (t == null || !t.isAlive()) continue;
                result = true;
            }
        }
        return result;
    }

    public void wrangle(OpticsObjectGroup optics, int num) {
        Collection<OpticsObject> os = optics.getFlattenedOpticsObjects(false);
        ArrayList<OpticsObject> group = new ArrayList<OpticsObject>();
        for (OpticsObject o : os) {
            if (o instanceof AutofocusSensor) continue;
            group.add(o);
        }
        this.wrangle(group, optics, num);
    }

    public void wrangle(final Collection<OpticsObject> objects, final OpticsObject optics, int num) {
        if (this.isWrangling()) {
            throw new RuntimeException("Wrangler is already running.");
        }
        this.clear();
        this.stopWranglerThread = false;
        this.m_curTraj = 0;
        this.m_numTraj = num;
        int n = Settings.SETTINGS.getNumberWranglerThreads();
        if (n > 3) {
            n = 3;
        }
        this.wranglerThreads = new Thread[n];
        for (int i = 0; i < this.wranglerThreads.length; ++i) {
            this.wranglerThreads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    PhotonWrangler.this.nonThreadWrangle(objects, optics, PhotonWrangler.this.m_numTraj);
                }
            });
            this.wranglerThreads[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nonThreadWrangle(Collection<OpticsObject> objects, OpticsObject outerObject, int numTraj) {
        ++this.m_wrangleCount;
        this.fireWranglerEventLater(WranglerEvent.Type.STARTED);
        LightSourceWrangler sourceWrangler = new LightSourceWrangler(objects);
        if (sourceWrangler.size() == 0) {
            System.out.println("PhotonWrangler.nonThreadWrangle no light sources specified in project.");
            return;
        }
        this.m_curTraj = 0;
        while (this.m_curTraj < numTraj) {
            if (this.m_curTraj % 1000 == 0 && this.m_curTraj != 0) {
                this.fireWranglerEventLater(WranglerEvent.Type.ONGOING);
            }
            InteractionSorter is = new InteractionSorter();
            PhotonTrajectory pt = sourceWrangler.getNextLightSource().getNewPhotonTrajectory(outerObject);
            while (!pt.isFinished() && !this.stopWranglerThread) {
                OpticsObject o2;
                is.clear();
                if (pt.isInOutermostObject()) {
                    for (OpticsObject o2 : objects) {
                        try {
                            o2.getPossibleInteraction(pt, is);
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    OpticsObject o3 = pt.getContainingObject();
                    o3.getPossibleInteraction(pt, is);
                    if (is.getShortest() == null) {
                        System.out.println("PhotonWrangler.nonThreadWrangle containing object did not interact.");
                    }
                }
                is.sort(pt.getInteraction());
                PhotonInteraction pi = is.getShortest();
                if (pi == null) {
                    System.out.println("PhotonWrangler.nonThreadWrangle no interaction found. Last object: " + pt.getPhoton().getPhotonSource());
                } else if (is.getDistanceBetweenShortests() < 1.0E-11) {
                    PhotonInteraction pi1 = is.getShortest();
                    PhotonInteraction pi2 = is.getNextShortest();
                    if (pi1.isInteractingWithSurface() && pi2.isInteractingWithSurface()) {
                        if (pi1.isFromInside() && !pi2.isFromInside()) {
                            pi = pi1.combine(pi2);
                        } else if (!pi1.isFromInside() && pi2.isFromInside()) {
                            pi = pi2.combine(pi1);
                        }
                    }
                } else if (!pi.isInteractingWithContainingObject() && pt.getContainingObject() != pt.getOutermostObject()) {
                    PhotonInteraction pi3 = is.getFirstInteractionWithObject(pt.getInteraction());
                    pi = pi3 == null ? pi.leaveObject(pt) : pi3;
                } else if (pt.getLeavingObject() != null && pt.getLeavingObject() == pi.getInteractingObject() && pt.getInteraction().isFromInside()) {
                    pi = is.getFirstInteractionNotWithSpecifiedObject(pi.getInteractingObject());
                }
                if (pi != null && pi.isValid()) {
                    pt.getMaterial().interact(pi, pt);
                    if (!pt.failedToPropagate()) {
                        if (pi.getComment().contains("ylinder")) {
                            System.out.println("Cylinder interaction");
                        }
                        pi.getInteractingObject().interact(pi, pt);
                        continue;
                    }
                    System.out.println("PhotonWrangler.nonThreadWrangle failed to propagate.");
                    continue;
                }
                o2 = pt.getPhoton().getContainingObject();
                if (!(o2 instanceof ProjectRootGroup)) {
                    OpticsProject p = PropertyManager.getInstance().getProject(o2);
                    Collection<OpticsObject> oos = p.getFlattenedOpticsObjects(false);
                    RotatedSpline spline = null;
                    for (OpticsObject ot : oos) {
                        if (!(ot instanceof RotatedSpline)) continue;
                        spline = (RotatedSpline)ot;
                        break;
                    }
                    is.clear();
                    if (spline != null) {
                        RotatedSplineInteractionCalculator.computeInteractions(pt, spline, is);
                    }
                    System.out.println("Photon should not be in an object right now.");
                }
                pt.losePhoton();
            }
            if (this.stopWranglerThread) break;
            PhotonWrangler photonWrangler = this;
            synchronized (photonWrangler) {
                this.m_trajectories.add(pt);
            }
            ++this.m_curTraj;
        }
        this.fireWranglerEventLater(WranglerEvent.Type.FINISHED);
        --this.m_wrangleCount;
    }

    public void stop() {
        this.stopWranglerThread = true;
    }

    public int getTotalCounts() {
        return this.m_numTraj;
    }

    public int getCurrentCount() {
        return this.m_curTraj;
    }

    public void addWranglerListener(WranglerListener listener) {
        if (!this.m_WranglerListeners.contains(listener)) {
            this.m_WranglerListeners.add(listener);
        }
    }

    public void removeWranglerListener(WranglerListener listener) {
        if (!this.m_WranglerListeners.contains(listener)) {
            this.m_WranglerListeners.remove(listener);
        }
    }

    private void fireWranglerEventLater(final WranglerEvent.Type type) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PhotonWrangler.this.fireWranglerEvent(type);
            }
        });
    }

    protected void fireWranglerEvent(WranglerEvent.Type type) {
        WranglerEvent e = new WranglerEvent(this, type);
        for (WranglerListener listener : this.m_WranglerListeners) {
            listener.wranglingUpdate(e);
        }
    }

    public class LimitedQueue<E>
    extends LinkedList<E> {
        private int limit;

        public LimitedQueue(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean add(E o) {
            super.add(o);
            while (this.size() > this.limit) {
                super.remove();
            }
            return true;
        }
    }

    public class LightSourceWrangler {
        private final List<LightSource> m_sources;
        private int m_sourceIndex;

        public LightSourceWrangler(Collection<OpticsObject> os) {
            this.m_sources = PhotonWrangler.this.getLightSources(os);
            this.m_sourceIndex = 0;
        }

        public LightSource getNextLightSource() {
            if (this.m_sources.size() == 0) {
                return null;
            }
            LightSource temp = this.m_sources.get(this.m_sourceIndex);
            if (++this.m_sourceIndex >= this.m_sources.size()) {
                this.m_sourceIndex = 0;
            }
            return temp;
        }

        public int size() {
            return this.m_sources.size();
        }
    }
}

