/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.photons;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import net.sourceforge.jocular.materials.OpticalMaterial;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.Polarization;

public class PhotonTrajectory {
    private final List<Photon> m_photons = new Vector<Photon>();
    private final List<PhotonInteraction> m_interactions = new Vector<PhotonInteraction>();
    private int i = 0;
    private static final int MAX_PHOTON_NUMBER = 100;

    public PhotonTrajectory(Photon p, PhotonInteraction pi) {
        this.addPhoton(p, pi);
    }

    public Photon getPhoton() {
        return this.m_photons.get(this.i);
    }

    public OpticalMaterial getMaterial() {
        OpticalMaterial result = null;
        OpticsObject o = this.getContainingObject();
        if (o != null) {
            result = o.getMaterial();
        }
        return result;
    }

    public boolean isCombined(int i) {
        PhotonInteraction pi = this.m_interactions.get(i);
        return pi.getFromObject() != null && pi.getToObject() != null;
    }

    public OpticsObject getObject() {
        return this.m_interactions.get(this.i).getInteractingObject();
    }

    public int getNumberOfPhotons() {
        return this.i + 1;
    }

    public OpticsObject getContainingObject() {
        OpticsObject po = this.getPhoton().getContainingObject();
        return po;
    }

    public OpticsObject getOutermostObject() {
        return this.m_photons.get(0).getContainingObject();
    }

    public OpticsObject getSourceObject(int i) {
        return this.m_interactions.get(i).getInteractingObject();
    }

    public String getComment(int j) {
        return this.m_interactions.get(j).getComment();
    }

    public Photon getPhoton(int j) {
        return this.m_photons.get(j);
    }

    public OpticalMaterial getMaterial(int j) {
        Photon p = this.getPhoton(j);
        OpticsObject o = p.getContainingObject();
        return o.getMaterial();
    }

    public void addPhoton(Photon p, PhotonInteraction pi) {
        if (p == null) {
            throw new RuntimeException("Photon should not be null.  ");
        }
        if (this.i > 100) {
            throw new RuntimeException("Photon number has exceeded limit.");
        }
        this.m_interactions.add(pi);
        this.m_photons.add(p);
        switch (p.getPhotonSource()) {
            case REFRACTED: {
                OpticsObject o1;
                if (pi.getFromObject() != null && (o1 = this.getContainingObject()) != pi.getFromObject()) {
                    throw new RuntimeException("Object that photon was in doesn't match one interacting with it: " + o1 + " and " + pi.getInteractingObject());
                }
                if (pi.getToObject() == null || pi.getToObject() != this.getContainingObject()) break;
                throw new RuntimeException("Why are we heading to an object that we're already in?");
            }
        }
        this.i = this.m_photons.size() - 1;
    }

    public Collection<Photon> getPhotons() {
        return this.m_photons;
    }

    public boolean isInOutermostObject() {
        return this.getContainingObject() == this.getOutermostObject();
    }

    public boolean isFinished() {
        Photon.PhotonSource ps = this.getPhoton().getPhotonSource();
        return ps == Photon.PhotonSource.ABSORBED || ps == Photon.PhotonSource.LOST || this.m_photons.size() >= 100;
    }

    public boolean failedToPropagate() {
        Photon.PhotonSource ps = this.getPhoton().getPhotonSource();
        return ps == Photon.PhotonSource.ABSORBED || ps == Photon.PhotonSource.LOST || ps == Photon.PhotonSource.SCATTERED;
    }

    public String toString() {
        Object result = "";
        int n = this.getNumberOfPhotons();
        result = (String)result + "PhotonTrajectory: " + n + " photons:";
        for (int i = 0; i < n; ++i) {
            Photon p = this.getPhoton(i);
            result = (String)result + "\n     " + p.getPhotonSource() + " in Object " + p.getContainingObject() + " of material " + p.getContainingObject().getMaterial() + ", " + this.getInteraction(i).getComment();
        }
        return result;
    }

    public void losePhoton() {
        Photon p = this.getPhoton();
        Vector3D o = p.getOrigin().add(p.getDirection().scale(1.0));
        Vector3D d = p.getDirection();
        double w = p.getWavelength();
        Polarization pol = p.getPolarization();
        Photon newP = new Photon(o, d, w, pol, Photon.PhotonSource.LOST, p.getIntensity(), p.getContainingObject());
        PhotonInteraction pi = new PhotonInteraction(this.getPhoton(), o, null, d, "Lost");
        this.addPhoton(newP, pi);
    }

    public void absorb(double distance, OpticsObject oo) {
        Photon p = this.getPhoton();
        Vector3D o = p.getOrigin().add(p.getDirection().scale(distance * 100.0));
        Vector3D d = p.getDirection();
        double w = p.getWavelength();
        Polarization pol = p.getPolarization();
        Photon newP = new Photon(o, d, w, pol, Photon.PhotonSource.ABSORBED, p.getIntensity(), oo);
        PhotonInteraction pi = new PhotonInteraction(this.getPhoton(), o, oo, d, "Absorbed");
        this.addPhoton(newP, pi);
        if (distance < 1.0E-4 || p.getContainingObject() == null) {
            System.out.println("PhotonTrajectory.absorb what the? " + this);
        }
    }

    public void absorb(PhotonInteraction pi) {
        Photon p = this.getPhoton();
        Vector3D d = p.getDirection();
        double w = p.getWavelength();
        OpticsObject oo = pi.getInteractingObject();
        Polarization pol = p.getPolarization();
        Photon newP = new Photon(pi.getLocation(), d, w, pol, Photon.PhotonSource.ABSORBED, p.getIntensity(), oo);
        this.addPhoton(newP, pi);
        System.out.println("PhotonTrajectory.absorb what the? " + this);
    }

    public PhotonInteraction getInteraction() {
        return this.m_interactions.get(this.i);
    }

    public PhotonInteraction getInteraction(int j) {
        return this.m_interactions.get(j);
    }

    public OpticsObject getLeavingObject() {
        OpticsObject result = null;
        if (this.getPhoton().getPhotonSource() == Photon.PhotonSource.REFRACTED) {
            result = this.getInteraction().getContainingObject();
        }
        return result;
    }
}

