/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.photons;

import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsSurface;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonTrajectory;

public class PhotonInteraction
implements Comparable<PhotonInteraction> {
    private final Photon m_photon;
    private final OpticsObject m_toObject;
    private final OpticsObject m_fromObject;
    private final Object m_refObject;
    private final Vector3D m_location;
    private final double m_distance;
    private final Vector3D m_normal;
    private final String m_comment;

    public PhotonInteraction(Photon p, OpticsObject interactionObject, Object ref, Vector3D loc, Vector3D normal, String comment) {
        this(p, interactionObject == p.getContainingObject() ? interactionObject : null, interactionObject == p.getContainingObject() ? null : interactionObject, ref, loc, normal, comment);
    }

    private PhotonInteraction(Photon p, OpticsObject fromObject, OpticsObject toObject, Object ref, Vector3D loc, Vector3D normal, String comment) {
        this.m_photon = p;
        this.m_toObject = toObject;
        this.m_fromObject = fromObject;
        this.m_refObject = ref;
        this.m_location = loc;
        this.m_distance = this.m_photon == null ? 0.0 : this.m_photon.getOrigin().distanceTo(this.m_location);
        if (Double.isNaN(this.m_distance)) {
            throw new RuntimeException("Distance is NaN. Object is " + toObject.getClass().getSimpleName() + ", location is " + this.m_location);
        }
        this.m_normal = normal;
        this.m_comment = comment;
    }

    public PhotonInteraction(Photon p, Vector3D loc, OpticsObject fromObject, Vector3D normal, String comment) {
        this.m_photon = p;
        this.m_toObject = null;
        this.m_fromObject = fromObject;
        this.m_refObject = null;
        this.m_location = loc;
        this.m_distance = this.m_photon == null ? 0.0 : this.m_photon.getOrigin().distanceTo(this.m_location);
        if (Double.isNaN(this.m_distance)) {
            throw new RuntimeException("Distance is NaN. Object is " + this.m_toObject.getClass().getSimpleName() + ", location is " + this.m_location);
        }
        this.m_normal = normal;
        this.m_comment = comment;
    }

    public PhotonInteraction combine(PhotonInteraction pi) {
        PhotonInteraction result = null;
        if (pi.m_toObject == this.m_fromObject) {
            result = new PhotonInteraction(this.m_photon, pi.m_fromObject, this.m_toObject, null, this.m_location, this.m_normal, this.m_comment + " (added from Object)");
        } else if (pi.m_fromObject == this.m_toObject) {
            result = new PhotonInteraction(this.m_photon, this.m_fromObject, pi.m_toObject, null, this.m_location, this.m_normal, this.m_comment + " (added from Object)");
        } else {
            throw new RuntimeException("Trying to combine interactions with no common object");
        }
        return result;
    }

    public PhotonInteraction leaveObject(PhotonTrajectory pt) {
        Photon p = this.m_photon;
        Photon nP = new Photon(this.getLocation(), p.getDirection(), p.getWavelength(), p.getPolarization(), Photon.PhotonSource.UNCHANGED, p.getIntensity(), pt.getOutermostObject());
        return new PhotonInteraction(nP, p.getContainingObject(), null, null, p.getOrigin(), this.m_normal, this.m_comment + " (left " + p.getContainingObject().getName() + ")");
    }

    public boolean isFromInside() {
        return this.m_photon.getContainingObject() == this.m_fromObject;
    }

    public Vector3D getLocation() {
        return this.m_location;
    }

    public Vector3D getNormal() {
        return this.m_normal;
    }

    public double getDistance() {
        return this.m_distance;
    }

    public boolean isCloserThan(PhotonInteraction pi) {
        return this.compareTo(pi) < 0;
    }

    public boolean isInteractingWithContainingObject() {
        return this.m_photon.getContainingObject() == this.getInteractingObject();
    }

    public boolean isInteractingWithSurface() {
        return this.getInteractingObject() instanceof OpticsSurface;
    }

    public OpticsObject getInteractingObject() {
        return this.m_toObject == null ? this.m_fromObject : this.m_toObject;
    }

    public OpticsObject getToObject() {
        return this.m_toObject;
    }

    public OpticsObject getFromObject() {
        return this.m_fromObject;
    }

    @Override
    public int compareTo(PhotonInteraction p) {
        int result = p == null ? -1 : (this.m_distance < p.m_distance ? -1 : (this.m_distance > p.m_distance ? 1 : 0));
        return result;
    }

    public boolean isValid() {
        return this.m_location != null && this.m_location != Vector3D.INF;
    }

    public String toString() {
        Object result = "PhotonInteraction";
        result = (String)result + ". with object: " + this.getInteractingObject();
        result = (String)result + " at location = ";
        result = this.m_location == null ? (String)result + "null." : (String)result + this.m_location;
        result = (String)result + "." + this.m_comment;
        return result;
    }

    public String getComment() {
        return this.m_comment;
    }

    public boolean isInteractingObject(PhotonInteraction last) {
        boolean result = false;
        if (this.m_toObject == last.getToObject() || this.m_fromObject == last.getToObject() || this.m_toObject == last.getFromObject() || this.m_fromObject == last.getFromObject()) {
            result = true;
        }
        return result;
    }

    public Object getReferenceObject() {
        return this.m_refObject;
    }

    public OpticsObject getContainingObject() {
        return this.m_photon.getContainingObject();
    }
}

