/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.photons;

import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.Polarization;

public class Photon {
    private final Vector3D m_origin;
    private final Vector3D m_direction;
    private final double wavelength;
    private final Polarization m_polarization;
    private final PhotonSource m_photonSource;
    private final double m_intensity;
    public static final double H = 6.6260695729E-34;
    public static final double HC = 1.98644568E-25;
    private final OpticsObject m_containingObject;

    public Photon(Vector3D origin, Vector3D v, double w, Polarization p, PhotonSource ps, double intensity, OpticsObject containingObject) {
        this.m_origin = origin;
        this.m_direction = v.normalize();
        this.wavelength = w;
        this.m_polarization = p;
        this.m_photonSource = ps;
        this.m_intensity = intensity;
        this.m_containingObject = containingObject;
        if (containingObject == null) {
            throw new RuntimeException("Containing object cannot be null!");
        }
    }

    public Polarization getPolarization() {
        return this.m_polarization;
    }

    public Vector3D getOrigin() {
        return this.m_origin;
    }

    public Vector3D getDirection() {
        return this.m_direction;
    }

    public double getIntensity() {
        return this.m_intensity;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public PhotonSource getPhotonSource() {
        return this.m_photonSource;
    }

    public Photon(Photon r) {
        this(r.getOrigin(), r.getDirection(), r.getWavelength(), r.getPolarization(), r.getPhotonSource(), r.getIntensity(), r.getContainingObject());
    }

    public OpticsObject getContainingObject() {
        return this.m_containingObject;
    }

    public String toString() {
        return "Photon: " + this.m_photonSource + " org: " + this.m_origin + " dir: " + this.m_direction + " inside: " + this.m_containingObject;
    }

    public static enum PhotonSource {
        EMITTED,
        REFLECTED,
        REFRACTED,
        ABSORBED,
        TRANSMITTED,
        UNCHANGED,
        LOST,
        SCATTERED;

    }
}

