/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.photons;

import java.util.ArrayList;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.PhotonInteraction;

public class InteractionSorter {
    private int m_shortestIndex = 0;
    private int m_nextShortestIndex = -1;
    private ArrayList<PhotonInteraction> m_interactions = new ArrayList();

    public void clear() {
        this.m_shortestIndex = 0;
        this.m_nextShortestIndex = -1;
        this.m_interactions.clear();
    }

    public void add(PhotonInteraction pi) {
        this.add(0, pi);
    }

    private void add(int i, PhotonInteraction pi) {
        ArrayList<PhotonInteraction> list = this.m_interactions;
        if (list.size() == 0) {
            list.add(pi);
        } else {
            for (int j = 0; j < list.size(); ++j) {
                if (list.get(j).getDistance() > pi.getDistance()) {
                    list.add(j, pi);
                    break;
                }
                if (j != list.size() - 1) continue;
                list.add(pi);
                break;
            }
        }
    }

    public void sort(PhotonInteraction lastInteraction) {
        this.m_shortestIndex = 0;
        for (int i = 0; i < this.m_interactions.size() && this.m_interactions.get(i).isInteractingObject(lastInteraction) && !(this.m_interactions.get(i).getDistance() >= 1.0E-9); ++i) {
            this.m_shortestIndex = i + 1;
        }
        this.m_nextShortestIndex = this.m_shortestIndex;
        if (this.m_interactions.size() <= this.m_shortestIndex) {
            return;
        }
        while (this.m_interactions.get(this.m_shortestIndex).getToObject() == this.m_interactions.get(this.m_nextShortestIndex).getToObject()) {
            ++this.m_nextShortestIndex;
            if (this.m_nextShortestIndex < this.m_interactions.size()) continue;
            this.m_nextShortestIndex = this.m_shortestIndex;
            break;
        }
    }

    public PhotonInteraction getShortest() {
        if (this.m_interactions.size() <= this.m_shortestIndex) {
            return null;
        }
        return this.m_interactions.get(this.m_shortestIndex);
    }

    public PhotonInteraction getNextShortest() {
        if (this.m_interactions.size() <= this.m_nextShortestIndex) {
            return null;
        }
        return this.m_interactions.get(this.m_nextShortestIndex);
    }

    public double getDistanceBetweenShortests() {
        if (this.m_interactions.size() > 1) {
            return this.m_interactions.get(this.m_nextShortestIndex).getDistance() - this.m_interactions.get(this.m_shortestIndex).getDistance();
        }
        return Double.POSITIVE_INFINITY;
    }

    public PhotonInteraction getFirstInteractionWithObject(PhotonInteraction last) {
        PhotonInteraction result = null;
        for (PhotonInteraction pi : this.m_interactions) {
            if (!pi.isInteractingObject(last)) continue;
            result = pi;
            break;
        }
        return result;
    }

    public PhotonInteraction getFirstInteractionNotWithSpecifiedObject(OpticsObject oo) {
        PhotonInteraction result = null;
        for (PhotonInteraction pi : this.m_interactions) {
            if (pi.getInteractingObject() == oo) continue;
            result = pi;
            break;
        }
        return result;
    }
}

