/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsSurface;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;

public class TriangularPrism
extends AbstractOpticsObject
implements OpticsSurface {
    private EquationProperty m_baseWidth = new EquationProperty("10mm", this, PropertyKey.WIDTH);
    private EquationProperty m_angle1 = new EquationProperty("30deg", this, PropertyKey.ANGLE_1);
    private EquationProperty m_angle2 = new EquationProperty("90deg", this, PropertyKey.ANGLE_2);
    private EquationProperty m_length = new EquationProperty("10mm", this, PropertyKey.LENGTH);
    private Vector3D[] m_topTriangleVertices = new Vector3D[3];
    private Vector3D[] m_bottomTriangleVertices = new Vector3D[3];

    public TriangularPrism() {
        this.doInternalCalcs();
    }

    @Override
    public void accept(OpticsObjectVisitor v) {
        v.visit(this);
    }

    public Vector3D[][] getVertices() {
        Vector3D[][] result = new Vector3D[2][3];
        result[0][0] = this.getPositioner().transform(this.m_topTriangleVertices[0]);
        result[0][1] = this.getPositioner().transform(this.m_topTriangleVertices[1]);
        result[0][2] = this.getPositioner().transform(this.m_topTriangleVertices[2]);
        result[1][0] = this.getPositioner().transform(this.m_bottomTriangleVertices[0]);
        result[1][1] = this.getPositioner().transform(this.m_bottomTriangleVertices[1]);
        result[1][2] = this.getPositioner().transform(this.m_bottomTriangleVertices[2]);
        return result;
    }

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
        Vector3D[][] ps = this.getVertices();
        Vector3D[][] testVectors = new Vector3D[][]{{ps[0][0], ps[0][1], ps[0][2]}, {ps[1][2], ps[1][1], ps[1][0]}, {ps[0][0], ps[0][2], ps[1][2], ps[1][0]}, {ps[0][2], ps[0][1], ps[1][1], ps[1][2]}, {ps[0][1], ps[0][0], ps[1][0], ps[1][1]}};
        Photon p = pt.getPhoton();
        for (Vector3D[] ts : testVectors) {
            PhotonInteraction i = this.getTriangleIntersection(ts, p);
            if (i == null) continue;
            is.add(i);
        }
    }

    @Override
    public void doInternalCalcs() {
        super.doInternalCalcs();
        double l = this.m_length.getValue().getBaseUnitValue();
        double w = this.m_baseWidth.getValue().getBaseUnitValue();
        double a1 = this.m_angle1.getValue().getBaseUnitValue();
        double a2 = this.m_angle2.getValue().getBaseUnitValue();
        double a3 = Math.PI - a1 - a2;
        double l2 = w / Math.sin(a3) * Math.sin(a2);
        double l1 = w / Math.sin(a3) * Math.sin(a1);
        double p1z = l2 * Math.sin(a1);
        double p1x = -(l2 * Math.cos(a1) - l1 * Math.cos(a2)) / 2.0;
        this.m_topTriangleVertices[0] = new Vector3D(w / 2.0, l / 2.0, 0.0);
        this.m_topTriangleVertices[1] = new Vector3D(p1x, l / 2.0, p1z);
        this.m_topTriangleVertices[2] = new Vector3D(-w / 2.0, l / 2.0, 0.0);
        this.m_bottomTriangleVertices[0] = new Vector3D(w / 2.0, -l / 2.0, 0.0);
        this.m_bottomTriangleVertices[1] = new Vector3D(p1x, -l / 2.0, p1z);
        this.m_bottomTriangleVertices[2] = new Vector3D(-w / 2.0, -l / 2.0, 0.0);
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case LENGTH: {
                this.m_length = new EquationProperty(s, this, key);
                break;
            }
            case WIDTH: {
                this.m_baseWidth = new EquationProperty(s, this, key);
                break;
            }
            case ANGLE_1: {
                this.m_angle1 = new EquationProperty(s, this, key);
                break;
            }
            case ANGLE_2: {
                this.m_angle2 = new EquationProperty(s, this, key);
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
        this.doInternalCalcs();
        if (this.getPropertyKeys().contains((Object)key)) {
            this.firePropertyUpdated(key);
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result;
        switch (key) {
            case LENGTH: {
                result = this.m_length;
                break;
            }
            case WIDTH: {
                result = this.m_baseWidth;
                break;
            }
            case ANGLE_1: {
                result = this.m_angle1;
                break;
            }
            case ANGLE_2: {
                result = this.m_angle2;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.INSIDE_MATERIAL, PropertyKey.WIDTH, PropertyKey.LENGTH, PropertyKey.ANGLE_1, PropertyKey.ANGLE_2));
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        TriangularPrism result = new TriangularPrism();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }

    protected PhotonInteraction getTriangleIntersection(Vector3D[] p, Photon ph) {
        double d;
        double s;
        Vector3D origin = ph.getOrigin();
        Vector3D direction = ph.getDirection();
        Vector3D n = p[1].subtract(p[0]).cross(p[2].subtract(p[0])).normalize();
        double dop = origin.subtract(p[0]).dot(n);
        if (dop < 0.0) {
            n = n.neg();
            dop = -dop;
        }
        if ((s = dop / (d = -n.dot(direction))) <= 0.0 || Double.isInfinite(s) || Double.isNaN(s)) {
            return null;
        }
        Vector3D i = direction.scale(s).add(origin);
        boolean inside = true;
        for (int j = 0; j < p.length; ++j) {
            int k = (j + 1) % p.length;
            double dot = p[j].subtract(p[k]).dot(i.subtract(p[k]));
            if (!(dot < 0.0)) continue;
            inside = false;
            break;
        }
        if (inside) {
            return new PhotonInteraction(ph, this, p, i, n, "Triangular prism interaction");
        }
        return null;
    }
}

