/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jocular.materials.OpticalMaterial;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsID;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsSurface;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.positioners.OffsetPositioner;
import net.sourceforge.jocular.project.OpticsObjectElement;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.EnumProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.MaterialProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;

public class SphericalLens
extends AbstractOpticsObject
implements OpticsObject,
OpticsSurface,
OpticsObjectElement {
    PropertyUpdatedListener m_objectListener;
    private final String FRONT_SURFACE = "Front Surface";
    private final String BACK_SURFACE = "Front Surface";
    private final String OUTER_SURFACE = "Front Surface";
    private double m_cylinderLength = 0.0;
    private double m_cylinderOffset = 0.0;
    private EquationProperty m_thickness = new EquationProperty("2cm", this, PropertyKey.THICKNESS);
    private EquationProperty m_frontRadius = new EquationProperty("10cm", this, PropertyKey.FRONT_RADIUS);
    private EquationProperty m_backRadius = new EquationProperty("10cm", this, PropertyKey.BACK_RADIUS);
    private EquationProperty m_diameter = new EquationProperty("5cm", this, PropertyKey.DIAMETER);
    private EnumProperty m_frontShape = new EnumProperty(SurfaceShape.CONCAVE, SurfaceShape.CONCAVE.name());
    private EnumProperty m_backShape = new EnumProperty(SurfaceShape.CONCAVE, SurfaceShape.CONCAVE.name());

    public SphericalLens() {
        this.m_objectListener = new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                SphericalLens.this.firePropertyUpdated(e.getPropertyKey());
            }
        };
        this.setPositioner(new OffsetPositioner());
        this.setProperty(PropertyKey.FRONT_RADIUS, "15cm");
        this.setProperty(PropertyKey.BACK_RADIUS, "20cm");
        this.setProperty(PropertyKey.DIAMETER, "5cm");
        this.setProperty(PropertyKey.THICKNESS, "5mm");
        this.setProperty(PropertyKey.INSIDE_MATERIAL, MaterialProperty.MaterialKey.BOROSILICATE.name());
    }

    private Vector3D getFrontSphereCentre() {
        Vector3D o = this.getPositioner().getOrigin();
        Vector3D d = this.getPositioner().getDirection();
        double offset = -this.m_thickness.getValue().getBaseUnitValue() / 2.0;
        double rad = this.m_frontRadius.getValue().getBaseUnitValue();
        switch ((SurfaceShape)((Object)this.m_frontShape.getValue())) {
            case CONCAVE: {
                offset -= rad;
                break;
            }
            case CONVEX: {
                offset += rad;
                break;
            }
        }
        return o.add(d.scale(offset));
    }

    private Vector3D getBackSphereCentre() {
        Vector3D o = this.getPositioner().getOrigin();
        Vector3D d = this.getPositioner().getDirection();
        double offset = this.m_thickness.getValue().getBaseUnitValue() / 2.0;
        double rad = this.m_backRadius.getValue().getBaseUnitValue();
        switch ((SurfaceShape)((Object)this.m_backShape.getValue())) {
            case CONCAVE: {
                offset += rad;
                break;
            }
            case CONVEX: {
                offset -= rad;
                break;
            }
        }
        return o.add(d.scale(offset));
    }

    private Vector3D getCylinderCentre() {
        Vector3D o = this.getPositioner().getOrigin();
        Vector3D d = this.getPositioner().getDirection();
        return o.add(d.scale(this.m_cylinderOffset));
    }

    @Override
    public void doInternalCalcs() {
        super.doInternalCalcs();
        double frontRadius = this.m_frontRadius.getValue().getBaseUnitValue();
        double backRadius = this.m_backRadius.getValue().getBaseUnitValue();
        double diameter = this.m_diameter.getValue().getBaseUnitValue();
        double thickness = this.m_thickness.getValue().getBaseUnitValue();
        if (frontRadius < diameter / 2.0 || backRadius < diameter / 2.0) {
            // empty if block
        }
        double t1 = frontRadius - Math.sqrt(Math.pow(frontRadius, 2.0) - Math.pow(diameter / 2.0, 2.0));
        double t2 = backRadius - Math.sqrt(Math.pow(backRadius, 2.0) - Math.pow(diameter / 2.0, 2.0));
        SurfaceShape frontShape = (SurfaceShape)((Object)this.m_frontShape.getValue());
        SurfaceShape backShape = (SurfaceShape)((Object)this.m_backShape.getValue());
        switch (frontShape) {
            case CONVEX: {
                t1 = -t1;
                break;
            }
            case FLAT: {
                t1 = 0.0;
                break;
            }
        }
        switch (backShape) {
            case CONVEX: {
                t2 = -t2;
                break;
            }
            case FLAT: {
                t2 = 0.0;
                break;
            }
        }
        double l = thickness + t1 + t2;
        if (l < 0.0) {
            // empty if block
        }
        if (Double.isInfinite(t2 + t1 + thickness) || Double.isNaN(t2 + t1 + thickness)) {
            t2 = 0.0;
            t1 = 0.0;
        }
        if (l > 0.0) {
            this.m_cylinderLength = l;
            this.m_cylinderOffset = thickness / 2.0 - t2 - l / 2.0;
        } else {
            this.m_cylinderLength = 0.0;
            this.m_cylinderOffset = 0.0;
        }
    }

    @Override
    public void setPositioner(ObjectPositioner op) {
        super.setPositioner(op);
    }

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
        Photon p = pt.getPhoton();
        PhotonInteraction pi = this.getPossibleSurfaceInteraction(p, (SurfaceShape)((Object)this.m_frontShape.getValue()), this.getFrontSphereCentre(), this.m_frontRadius.getValue().getBaseUnitValue(), "Front Surface");
        if (pi != null) {
            is.add(pi);
        }
        if ((pi = this.getPossibleSurfaceInteraction(p, (SurfaceShape)((Object)this.m_backShape.getValue()), this.getBackSphereCentre(), this.m_backRadius.getValue().getBaseUnitValue(), "Front Surface")) != null) {
            is.add(pi);
        }
        if ((pi = this.getPossibleCylinderInteraction(p)) != null) {
            is.add(pi);
        }
    }

    @Override
    public OpticsObject makeCopy() {
        SphericalLens result = new SphericalLens();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case FRONT_RADIUS: {
                this.m_frontRadius = new EquationProperty(s, this, key);
                this.doInternalCalcs();
                break;
            }
            case FRONT_SHAPE: {
                this.m_frontShape = new EnumProperty(SurfaceShape.CONCAVE, s);
                this.doInternalCalcs();
                break;
            }
            case BACK_RADIUS: {
                this.m_backRadius = new EquationProperty(s, this, key);
                this.doInternalCalcs();
                break;
            }
            case BACK_SHAPE: {
                this.m_backShape = new EnumProperty(SurfaceShape.CONCAVE, s);
                this.doInternalCalcs();
                break;
            }
            case DIAMETER: {
                this.m_diameter = new EquationProperty(s, this, key);
                this.doInternalCalcs();
                break;
            }
            case THICKNESS: {
                this.m_thickness = new EquationProperty(s, this, key);
                this.doInternalCalcs();
                break;
            }
            case INSIDE_MATERIAL: {
                super.setProperty(PropertyKey.INSIDE_MATERIAL, s);
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
        if (this.getPropertyKeys().contains((Object)key)) {
            this.firePropertyUpdated(key);
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result;
        switch (key) {
            case FRONT_RADIUS: {
                result = this.m_frontRadius;
                break;
            }
            case FRONT_SHAPE: {
                result = this.m_frontShape;
                break;
            }
            case BACK_RADIUS: {
                result = this.m_backRadius;
                break;
            }
            case BACK_SHAPE: {
                result = this.m_backShape;
                break;
            }
            case DIAMETER: {
                result = this.m_diameter;
                break;
            }
            case THICKNESS: {
                result = this.m_thickness;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.DIAMETER, PropertyKey.THICKNESS, PropertyKey.FRONT_SHAPE, PropertyKey.FRONT_RADIUS, PropertyKey.BACK_SHAPE, PropertyKey.BACK_RADIUS, PropertyKey.INSIDE_MATERIAL));
        return result;
    }

    @Override
    public void accept(OpticsObjectVisitor visitor) {
        visitor.visit(this);
    }

    public double getFocalLength(double w) {
        double r1 = ((EquationProperty)this.getProperty(PropertyKey.FRONT_RADIUS)).getValue().getBaseUnitValue();
        double r2 = ((EquationProperty)this.getProperty(PropertyKey.BACK_RADIUS)).getValue().getBaseUnitValue();
        double oneOverR1 = 1.0 / r1;
        double oneOverR2 = -1.0 / r2;
        double t = ((EquationProperty)this.getProperty(PropertyKey.THICKNESS)).getValue().getBaseUnitValue();
        SurfaceShape shape1 = (SurfaceShape)((Object)this.getProperty(PropertyKey.FRONT_SHAPE).getValue());
        SurfaceShape shape2 = (SurfaceShape)((Object)this.getProperty(PropertyKey.BACK_SHAPE).getValue());
        switch (shape1) {
            default: {
                break;
            }
            case CONCAVE: {
                oneOverR1 = -oneOverR1;
                break;
            }
            case FLAT: {
                oneOverR1 = 0.0;
            }
        }
        switch (shape2) {
            default: {
                break;
            }
            case CONCAVE: {
                oneOverR2 = -oneOverR2;
                break;
            }
            case FLAT: {
                oneOverR2 = 0.0;
            }
        }
        OpticalMaterial m = ((MaterialProperty)this.getProperty(PropertyKey.INSIDE_MATERIAL)).getValue();
        double n = m.getOrdinaryRefractiveIndex(w);
        double oneOverF = (n - 1.0) * (oneOverR1 - oneOverR2 + (n - 1.0) / n * t * oneOverR1 * oneOverR2);
        return 1.0 / oneOverF;
    }

    @Override
    public void setID(OpticsID id) {
        super.setID(id);
    }

    private PhotonInteraction getPossibleSurfaceInteraction(Photon p, SurfaceShape ss, Vector3D centre, double radius, Object objectRef) {
        Vector3D pResult;
        Vector3D objectLoc = this.getPositioner().getOrigin();
        Vector3D origin = p.getOrigin();
        Vector3D direction = p.getDirection();
        Vector3D normal = null;
        boolean fromInside = false;
        switch (ss) {
            default: {
                Vector3D c = centre;
                Vector3D o = origin;
                Vector3D l = direction.normalize();
                Vector3D d = c.subtract(o);
                double dot = l.dot(d);
                double sqrt = Math.pow(dot, 2.0) - d.magSquared() + Math.pow(radius, 2.0);
                if (sqrt < 0.0) {
                    pResult = null;
                } else {
                    sqrt = Math.sqrt(sqrt);
                    double dist1 = dot - sqrt;
                    double dist2 = dot + sqrt;
                    Vector3D p1 = o.add(l.scale(dist1));
                    Vector3D p2 = o.add(l.scale(dist2));
                    Vector3D dir = this.getPositioner().getDirection();
                    double dia1 = p1.subtract(c).getPerpendicularComponent(dir).abs() * 2.0;
                    double dia2 = p2.subtract(c).getPerpendicularComponent(dir).abs() * 2.0;
                    if (dia1 > this.m_diameter.getValue().getBaseUnitValue()) {
                        p1 = null;
                    }
                    if (dia2 > this.m_diameter.getValue().getBaseUnitValue()) {
                        p2 = null;
                    }
                    if (!this.isOnFrontHemisphere(p1, ss, centre, objectLoc)) {
                        p1 = null;
                    }
                    if (!this.isOnFrontHemisphere(p2, ss, centre, objectLoc)) {
                        p2 = null;
                    }
                    if (p1 != null && p1.subtract(origin).dot(direction) <= -1.0E-11) {
                        p1 = null;
                    }
                    if (p2 != null && p2.subtract(origin).dot(direction) <= -1.0E-11) {
                        p2 = null;
                    }
                    pResult = p1 != null && p2 != null ? (dist1 < dist2 ? p1 : p2) : (p1 != null ? p1 : (p2 != null ? p2 : null));
                }
                if (pResult == null) break;
                normal = centre.subtract(pResult).normalize();
                if (ss != SurfaceShape.CONCAVE) break;
                normal = normal.neg();
                break;
            }
            case FLAT: {
                Vector3D oNew;
                Vector3D sO = this.getPositioner().getOrigin();
                Vector3D sD = this.getPositioner().getDirection();
                Vector3D pO = origin;
                Vector3D pD = direction;
                double cos = sD.dot(pD);
                double oDist = sO.subtract(pO).dot(sD);
                double dDist = 0.0;
                if (cos != 0.0) {
                    dDist = oDist / cos;
                }
                if ((pResult = dDist <= 0.0 ? null : ((oNew = pD.scale(dDist).add(pO)).distanceTo(sO) > this.m_diameter.getValue().getBaseUnitValue() / 2.0 ? null : oNew)) == null) break;
                normal = this.getPositioner().getDirection();
            }
        }
        PhotonInteraction pi = null;
        if (pResult != null) {
            pi = new PhotonInteraction(p, this, objectRef, pResult, normal, "Spherical Interaction: " + ss);
        }
        return pi;
    }

    public PhotonInteraction getPossibleCylinderInteraction(Photon p) {
        double c;
        Vector3D po = p.getOrigin();
        Vector3D pd = p.getDirection();
        Vector3D co = this.getPositioner().getOrigin();
        Vector3D cd = this.getPositioner().getDirection();
        co = co.add(cd.scale(this.m_cylinderOffset));
        Vector3D poI = po.subtract(co);
        Vector3D pdII = pd.getPerpendicularComponent(cd);
        double pdIImag = pdII.abs();
        if (pdIImag < 1.0E-20) {
            return null;
        }
        Vector3D poII = poI.getPerpendicularComponent(cd);
        double r = this.m_diameter.getValue().getBaseUnitValue() / 2.0;
        double b = 2.0 * pdII.dot(poII) / pdIImag;
        double sqrt = b * b - 4.0 * (c = poII.magSquared() - Math.pow(r, 2.0));
        if (sqrt < 0.0) {
            return null;
        }
        sqrt = Math.sqrt(sqrt);
        double x1 = (-b + sqrt) / 2.0;
        double x2 = (-b - sqrt) / 2.0;
        if (x1 < 0.0 && x2 < 0.0) {
            return null;
        }
        double x = x1 < 0.0 ? x2 : (x2 < 0.0 ? x1 : (x1 < x2 ? x1 : x2));
        Vector3D pdScaled = pd.scale(x / pdIImag);
        Vector3D intersection = po.add(pdScaled);
        double length = this.m_cylinderLength;
        double d = Math.abs(intersection.subtract(co).dot(cd));
        if (d > this.m_cylinderLength / 2.0) {
            return null;
        }
        Vector3D n = intersection.subtract(co).getPerpendicularComponent(cd).normalize();
        PhotonInteraction result = new PhotonInteraction(p, this, "Front Surface", intersection, n, "Cylinder interaction");
        return result;
    }

    private boolean isOnFrontHemisphere(Vector3D p, SurfaceShape ss, Vector3D centre, Vector3D objectLoc) {
        if (p == null) {
            return false;
        }
        boolean result = false;
        switch (ss) {
            case CONCAVE: 
            case CONVEX: {
                Vector3D c = centre;
                Vector3D o = objectLoc;
                Vector3D deltaP = c.subtract(p);
                Vector3D deltaO = c.subtract(o);
                double dot = deltaP.dot(deltaO);
                if (!(dot >= 0.0)) break;
                result = true;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    public static enum SurfaceShape {
        CONCAVE("Concave"),
        CONVEX("Convex"),
        FLAT("Flat");

        private final String m_name;

        private SurfaceShape(String n2) {
            this.m_name = n2;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

