/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OutputObject;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.IntegerProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;

public class SpectroPhotometer
extends AbstractOpticsObject
implements OutputObject {
    private EquationProperty m_diameter = new EquationProperty("10cm", this, PropertyKey.DIAMETER);
    private EquationProperty m_minWavelength = new EquationProperty("200nm", this, PropertyKey.WAVELENGTH_MIN);
    private EquationProperty m_maxWavelength = new EquationProperty("1000nm", this, PropertyKey.WAVELENGTH_MAX);
    private IntegerProperty m_numBins = new IntegerProperty("100");
    private double[] m_bins;
    private double[] m_wavelengths;
    private double m_totalEnergy = 0.0;
    private double m_lnR;
    private double m_lnA0;

    public SpectroPhotometer() {
        this.clear();
    }

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
        double dotF;
        double normDist;
        double dist;
        Vector3D pP;
        double dia;
        Photon photon = pt.getPhoton();
        Vector3D origin = photon.getOrigin();
        Vector3D direction = photon.getDirection();
        Vector3D p2this = this.getPositioner().getOrigin().subtract(origin);
        Vector3D pResult = p2this.dot(direction) <= 0.0 ? null : ((dia = (pP = origin.add(direction.scale(dist = (normDist = Math.abs(p2this.dot(this.getPositioner().getDirection()))) / (dotF = Math.abs(direction.dot(this.getPositioner().getDirection())))))).subtract(this.getPositioner().getOrigin()).abs() * 2.0) > this.m_diameter.getValue().getBaseUnitValue() ? null : pP);
        if (pResult != null) {
            is.add(new PhotonInteraction(photon, this, null, pResult, null, ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interact(PhotonInteraction pi, PhotonTrajectory pt) {
        this.addPhoton(pt.getPhoton());
        SpectroPhotometer spectroPhotometer = this;
        synchronized (spectroPhotometer) {
            Photon p = pt.getPhoton();
            Photon nP = new Photon(pi.getLocation(), p.getDirection(), p.getWavelength(), p.getPolarization(), Photon.PhotonSource.UNCHANGED, p.getIntensity(), p.getContainingObject());
            pt.addPhoton(new Photon(nP), pi);
        }
    }

    protected void addPhoton(Photon p) {
        double w = p.getWavelength();
        double deltaE = p.getIntensity() * 1.98644568E-25 / w;
        int i = this.getBinIndex(w);
        if (i != -1) {
            int n = i;
            this.m_bins[n] = this.m_bins[n] + deltaE;
        }
        this.m_totalEnergy += deltaE;
    }

    @Override
    public void clear() {
        this.m_totalEnergy = 0.0;
        this.m_bins = new double[this.m_numBins.getValue().intValue()];
        this.m_wavelengths = new double[this.m_numBins.getValue().intValue()];
        this.m_lnR = Math.log(this.m_maxWavelength.getValue().getBaseUnitValue() / this.m_minWavelength.getValue().getBaseUnitValue()) / (double)(this.m_numBins.getValue() - 1);
        this.m_lnA0 = Math.log(this.m_minWavelength.getValue().getBaseUnitValue()) - this.m_lnR / 2.0;
        for (int i = 0; i < this.m_bins.length; ++i) {
            this.m_bins[i] = 0.0;
            this.m_wavelengths[i] = Math.exp(this.m_lnA0 + this.m_lnR * ((double)i + 0.5));
        }
    }

    public double[] getBinValues() {
        return this.m_bins;
    }

    public double[] getBinCentres() {
        return this.m_wavelengths;
    }

    protected int getBinIndex(double w) {
        double lnw = Math.log(w);
        double i = Math.floor((lnw - this.m_lnA0) / this.m_lnR);
        int result = (int)i;
        if (result >= this.m_numBins.getValue() || result < 0) {
            result = -1;
        }
        return result;
    }

    @Override
    public void accept(OpticsObjectVisitor v) {
        v.visit(this);
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case DIAMETER: {
                this.m_diameter = new EquationProperty(s, this, key);
                break;
            }
            case WAVELENGTH_MIN: {
                this.m_minWavelength = new EquationProperty(s, this, key);
                this.clear();
                break;
            }
            case WAVELENGTH_MAX: {
                this.m_maxWavelength = new EquationProperty(s, this, key);
                this.clear();
                break;
            }
            case NUM_BINS: {
                this.m_numBins = new IntegerProperty(s);
                this.clear();
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result = null;
        switch (key) {
            case DIAMETER: {
                result = this.m_diameter;
                break;
            }
            case WAVELENGTH_MIN: {
                result = this.m_minWavelength;
                break;
            }
            case WAVELENGTH_MAX: {
                result = this.m_maxWavelength;
                break;
            }
            case NUM_BINS: {
                result = this.m_numBins;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.DIAMETER, PropertyKey.WAVELENGTH_MIN, PropertyKey.WAVELENGTH_MAX, PropertyKey.NUM_BINS));
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        SpectroPhotometer result = new SpectroPhotometer();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }

    @Override
    public void doInternalCalcs() {
        super.doInternalCalcs();
    }

    public double getTotalEnergy() {
        return this.m_totalEnergy;
    }
}

