/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;

public class SimpleAperture
extends AbstractOpticsObject {
    private EquationProperty m_outerDiameter = new EquationProperty(0.01);
    private EquationProperty m_apertureDiameter = new EquationProperty(0.001);

    @Override
    public void accept(OpticsObjectVisitor v) {
        v.visit(this);
    }

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
        Vector3D oNew;
        double d;
        Vector3D pResult;
        Photon photon = pt.getPhoton();
        Vector3D sO = this.getPositioner().getOrigin();
        Vector3D sD = this.getPositioner().getDirection();
        Vector3D pO = photon.getOrigin();
        Vector3D pD = photon.getDirection();
        double cos = sD.dot(pD);
        double oDist = sO.subtract(pO).dot(sD);
        double dDist = 0.0;
        if (cos != 0.0) {
            dDist = oDist / cos;
        }
        if ((pResult = dDist <= 0.0 ? null : ((d = (oNew = pD.scale(dDist).add(pO)).distanceTo(sO)) > this.m_outerDiameter.getValue().getBaseUnitValue() / 2.0 || d < this.m_apertureDiameter.getValue().getBaseUnitValue() / 2.0 ? null : oNew)) != null) {
            is.add(new PhotonInteraction(photon, this, null, pResult, null, "" + dDist));
        }
    }

    @Override
    public void interact(PhotonInteraction pi, PhotonTrajectory pt) {
        System.out.println("simpleAperture.interact absorbing");
        pt.absorb(pi);
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case DIAMETER: {
                this.m_apertureDiameter = new EquationProperty(s, this, key);
                break;
            }
            case OUTER_DIAMETER: {
                this.m_outerDiameter = new EquationProperty(s, this, key);
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
        if (this.getPropertyKeys().contains((Object)key)) {
            this.firePropertyUpdated(key);
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result = null;
        switch (key) {
            case DIAMETER: {
                result = this.m_apertureDiameter;
                break;
            }
            case OUTER_DIAMETER: {
                result = this.m_outerDiameter;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.DIAMETER, PropertyKey.OUTER_DIAMETER));
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        SimpleAperture result = new SimpleAperture();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }
}

