/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.EnumProperty;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.splines.RotatedSpline;
import net.sourceforge.jocular.splines.SplineObject;

public class PlanoAsphericLens
extends RotatedSpline {
    private EquationProperty m_radius = new EquationProperty("25mm", this, PropertyKey.RADIUS);
    private EquationProperty m_diameter = new EquationProperty("25mm", this, PropertyKey.DIAMETER);
    private EquationProperty m_conicCoefficient = new EquationProperty("0.25", this, PropertyKey.CONIC_COEFF);
    private EquationArrayProperty m_polyCoefficents = new EquationArrayProperty("0,0", (PropertyOwner)this, PropertyKey.POLY_COEFFS);
    private EquationProperty m_thickness = new EquationProperty("10mm", this, PropertyKey.THICKNESS);
    private EnumProperty m_units = new EnumProperty(Units.MM, Units.MM.name());
    private static final int SPLINE_POINT_COUNT = 20;

    public PlanoAsphericLens() {
        this.setProperty(PropertyKey.SIMPLIFY_THRESHOLD, "100e-12");
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.THICKNESS, PropertyKey.DIAMETER, PropertyKey.RADIUS, PropertyKey.COEFF_UNITS, PropertyKey.CONIC_COEFF, PropertyKey.POLY_COEFFS, PropertyKey.INSIDE_MATERIAL));
        return result;
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case RADIUS: {
                this.m_radius = new EquationProperty(s, this, key);
                this.doInternalCalcs();
                this.firePropertyUpdated(key);
                break;
            }
            case DIAMETER: {
                this.m_diameter = new EquationProperty(s, this, key);
                this.doInternalCalcs();
                this.firePropertyUpdated(key);
                break;
            }
            case COEFF_UNITS: {
                this.m_units = new EnumProperty(Units.MM, s);
                this.doInternalCalcs();
                this.firePropertyUpdated(key);
                break;
            }
            case CONIC_COEFF: {
                this.m_conicCoefficient = new EquationProperty(s, this, key);
                this.doInternalCalcs();
                this.firePropertyUpdated(key);
                break;
            }
            case POLY_COEFFS: {
                this.m_polyCoefficents = new EquationArrayProperty(s, (PropertyOwner)this, key);
                this.doInternalCalcs();
                this.firePropertyUpdated(key);
                break;
            }
            case THICKNESS: {
                this.m_thickness = new EquationProperty(s, this, key);
                this.doInternalCalcs();
                this.firePropertyUpdated(key);
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result;
        switch (key) {
            case RADIUS: {
                result = this.m_radius;
                break;
            }
            case COEFF_UNITS: {
                result = this.m_units;
                break;
            }
            case CONIC_COEFF: {
                result = this.m_conicCoefficient;
                break;
            }
            case POLY_COEFFS: {
                result = this.m_polyCoefficents;
                break;
            }
            case DIAMETER: {
                result = this.m_diameter;
                break;
            }
            case THICKNESS: {
                result = this.m_thickness;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        PlanoAsphericLens result = new PlanoAsphericLens();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }

    @Override
    public int getSplinePointCount() {
        return 22;
    }

    @Override
    public double[] getSplinePointDepValues() {
        double rad = this.m_diameter.getValue().getBaseUnitValue() / 2.0;
        double[] result = new double[this.getSplinePointCount()];
        for (int i = 0; i < 20; ++i) {
            result[i] = (double)i * rad / 19.0;
        }
        result[20] = rad;
        result[21] = 0.0;
        return result;
    }

    @Override
    public double[] getSplinePointIndepValues() {
        double thick = this.m_thickness.getValue().getBaseUnitValue();
        double rad = this.m_radius.getValue().getBaseUnitValue();
        double conic = this.m_conicCoefficient.getValue().getBaseUnitValue();
        Units u = (Units)((Object)this.m_units.getValue());
        double scale = 1.0;
        switch (u) {
            case MM: {
                scale = 1000.0;
                break;
            }
            default: {
                scale = 1.0;
                break;
            }
            case INCHES: {
                scale = 39.37007874015748;
            }
        }
        UnitedValue[] vas = this.m_polyCoefficents.getValue();
        double[] as = new double[vas.length];
        for (int i = 0; i < vas.length; ++i) {
            as[i] = vas[i].getBaseUnitValue();
        }
        double[] result = new double[this.getSplinePointCount()];
        double[] rads = this.getSplinePointDepValues();
        result[0] = this.computeZOfR(0.0, rad, conic, as);
        for (int i = 1; i < 20; ++i) {
            result[i] = this.computeZOfR(rads[i] * scale, rad * scale, conic, as) / scale;
            result[i] = -thick / 2.0 + result[i] - result[0];
            if (!Double.isNaN(result[i])) continue;
            throw new RuntimeException("Spline value is NaN.");
        }
        result[0] = -thick / 2.0;
        result[20] = thick / 2.0;
        result[21] = thick / 2.0;
        return result;
    }

    @Override
    public SplineObject.PointType[] getSplinePointTypes() {
        SplineObject.PointType[] result = new SplineObject.PointType[this.getSplinePointCount()];
        for (int i = 0; i < 20; ++i) {
            result[i] = SplineObject.PointType.SMOOTH;
        }
        result[0] = SplineObject.PointType.SQUARE;
        result[19] = SplineObject.PointType.CUSP;
        result[20] = SplineObject.PointType.CUSP;
        result[21] = SplineObject.PointType.CUSP;
        return result;
    }

    private double computeZOfR(double r, double rad, double conic, double[] as) {
        double result = 0.0;
        double r2 = r * r;
        double sqr = 1.0 - (1.0 + conic) * r2 / rad / rad;
        if (sqr >= 0.0) {
            result = r2 / rad / (1.0 + Math.sqrt(sqr));
            double rn = r2;
            for (int i = 0; i < as.length; ++i) {
                result += rn * as[i];
                rn *= r2;
            }
        } else {
            result = 0.0;
        }
        return result;
    }

    @Override
    public void accept(OpticsObjectVisitor v) {
        v.visit(this);
    }

    public static enum Units {
        MM,
        M,
        INCHES;

    }
}

