/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.objects;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.positioners.OffsetPositioner;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.FileProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.properties.PropertyOwner;

public class OpticsPart
extends OpticsObjectGroup {
    private OpticsProject m_project = null;
    private FileProperty m_file = new FileProperty((PropertyOwner)this, "");

    public OpticsPart() {
        this.setPositioner(new OffsetPositioner());
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case FILE_NAME: {
                this.m_file = new FileProperty((PropertyOwner)this, s);
                this.setProject(this.m_file);
                this.firePropertyUpdated(key);
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<File> result = null;
        switch (key) {
            case FILE_NAME: {
                result = this.m_file;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.FILE_NAME));
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        OpticsPart result = new OpticsPart();
        result.copyEverything(this);
        return result;
    }

    public void setProject(FileProperty projectFile) {
        OpticsProject project;
        if (projectFile.getValue() != null && (project = OpticsProject.loadProject(projectFile.getValue())) != null) {
            this.m_project = project;
            PropertyManager.getInstance().addProject(project);
            ProjectRootGroup g = project.getOpticsObject();
            this.getObjects().clear();
            this.add(g, 0);
            g.setPositioner(new OffsetPositioner());
            PropertyManager.getInstance().undeferParsing(this.m_project);
        }
    }

    @Override
    public void accept(OpticsObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void doInternalCalcs() {
        this.setProject(this.m_file);
        super.doInternalCalcs();
    }
}

