/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.objects;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.sourceforge.jocular.autofocus.AutofocusSensor;
import net.sourceforge.jocular.imager.Imager;
import net.sourceforge.jocular.mesh.MeshOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.OpticsPart;
import net.sourceforge.jocular.objects.PlanoAsphericLens;
import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.objects.SimpleAperture;
import net.sourceforge.jocular.objects.SpectroPhotometer;
import net.sourceforge.jocular.objects.SphericalLens;
import net.sourceforge.jocular.objects.TriangularPrism;
import net.sourceforge.jocular.sources.HemiPointSource;
import net.sourceforge.jocular.sources.ImageSource;
import net.sourceforge.jocular.splines.ExtrudedSpline;
import net.sourceforge.jocular.splines.RotatedSpline;

public enum OpticsObjectKey {
    SPHERICAL_LENS("Spherical Lens", new SphericalLens(), "SphericalLens.png", "A simple lens with front and back spherical surface and an outer diameter"),
    OPTICS_GROUP("Group", new OpticsObjectGroup(), "OpticsObjectGroup.png", "A group of objects"),
    IMAGER("Imager", new Imager(), "Imager.png", "A RGB sensor for generating simulated images."),
    POINT_SOURCE("Point Source", new HemiPointSource(), "PointSource.png", "A point source of light."),
    ROOT_GROUP("Root Group", new ProjectRootGroup(), "RootGroup.png", "The root of a project tree."),
    TRIANGULAR_PRISM("Triangular Prism", new TriangularPrism(), "TriangularPrism.png", "A triangular prism."),
    IMAGE_SOURCE("Image Source", new ImageSource(), "ImageSource.png", "An image source."),
    SIMPLE_APERTURE("Simple Aperture", new SimpleAperture(), "SimpleAperture.png", "A simple aperture."),
    SPECTROPHOTOMETER("Spectrophotometer", new SpectroPhotometer(), "SpectroPhotometer.png", "A spectrophotometer."),
    AUTOFOCUS_SENSOR("Autofocus Sensor", new AutofocusSensor(), "AutofocusSensor.png", "An autofocus sensor."),
    ROTATED_SPLINE("Rotated Spline", new RotatedSpline(), "RotatedSpline.png", "An object defined by rotating a spline curve."),
    EXTRUDED_SPLINE("Extruded Spline", new ExtrudedSpline(), "ExtrudedSpline.png", "An object defined by extruded a spline curve."),
    PLANO_ASPHERIC_LENS("Plano-Aspheric Lens", new PlanoAsphericLens(), "PlanoAsphericLens.png", "A lens with one flat side and one aspheric side difined by a base radius, a conic coefficient and a series of polynomial coefficients."),
    PART("Part", new OpticsPart(), "Part.png", "A part based on a specified project."),
    MESH_OBJECT("Mesh Object", new MeshOpticsObject(), "meshObject.png", "An object based on a Mesh file like STL.");

    private String name;
    private OpticsObject prototype;
    private Icon icon;
    private String tooltip;

    private OpticsObjectKey(String n2, OpticsObject o, String i, String t) {
        this.name = n2;
        this.prototype = o;
        this.tooltip = t;
        if (i == null) {
            this.icon = null;
        } else {
            Class<?> c = null;
            URL url = null;
            c = i.getClass();
            if (c != null) {
                url = c.getResource("/net/sourceforge/jocular/icons/" + n2);
            }
            if (url != null) {
                this.icon = new ImageIcon(url);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public OpticsObject getNewObject() {
        return this.prototype.makeCopy();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public static OpticsObjectKey getKey(String objectToMatch) {
        OpticsObjectKey[] opticsObjectKeyArray = OpticsObjectKey.values();
        int n = opticsObjectKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpticsObjectKey key = opticsObjectKeyArray[n2];
            if (objectToMatch.equals(key.name())) {
                return key;
            }
            ++n2;
        }
        return null;
    }

    public static String getKeyName(OpticsObject p) {
        String result = null;
        OpticsObjectKey[] opticsObjectKeyArray = OpticsObjectKey.values();
        int n = opticsObjectKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpticsObjectKey k = opticsObjectKeyArray[n2];
            if (k.prototype.getClass() == p.getClass()) {
                result = k.name();
                break;
            }
            ++n2;
        }
        return result;
    }
}

